/*  testFullAdj2.c  */

#include "../DInpMtx.h"
#include "../../Drand.h"

/*--------------------------------------------------------------------*/

void
main ( int argc, char *argv[] )
/*
   ----------------------------------------------------------
   generate random DInpMtx object for matrices A and B
   return an IVL object with the structure of (A+B) + (A+B)^T

   created -- 97nov05, cca
   ----------------------------------------------------------
*/
{
Drand     *drand ;
int       msglvl, ient, irow, jcol, nentA, nentB, nvtx, rc, seed ;
DInpMtx   *inpmtxA, *inpmtxB ;
FILE      *msgFile ;
IVL       *adjIVL ;

if ( argc != 7 ) {
   fprintf(stdout, 
      "\n\n usage : testFullAdj2 msglvl msgFile nvtx nentA nentB seed"
      "\n    msglvl  -- message level"
      "\n    msgFile -- message file"
      "\n    nvtx    -- number of rows and columns"
      "\n    nentA   -- bound on number of entries in A"
      "\n    nentB   -- bound on number of entries in B"
      "\n    seed    -- random number seed"
      "\n") ;
   return ;
}
msglvl = atoi(argv[1]) ;
if ( strcmp(argv[2], "stdout") == 0 ) {
   msgFile = stdout ;
} else if ( (msgFile = fopen(argv[2], "a")) == NULL ) {
   fprintf(stderr, "\n fatal error in %s"
           "\n unable to open file %s\n",
           argv[0], argv[2]) ;
   return ;
}
nvtx  = atoi(argv[3]) ;
nentA = atoi(argv[4]) ;
nentB = atoi(argv[5]) ;
seed  = atoi(argv[6]) ;
fprintf(msgFile, 
        "\n testIO "
        "\n msglvl   -- %d" 
        "\n msgFile  -- %s" 
        "\n nvtx     -- %d" 
        "\n nentA    -- %d" 
        "\n nentB    -- %d" 
        "\n seed     -- %d" 
        "\n",
        msglvl, argv[2], nvtx, nentA, nentB, seed) ;
fflush(msgFile) ;
/*
   --------------------------------------
   initialize the random number generator
   --------------------------------------
*/
drand = Drand_new() ;
Drand_setSeed(drand, seed) ;
Drand_setUniform(drand, 0, nvtx) ;
/*
   -----------------------------------
   initialize the DInpMtx object for A
   -----------------------------------
*/
inpmtxA = DInpMtx_new() ;
DInpMtx_init(inpmtxA, 1, 1, nentA, nvtx) ;
/*
   ----------------------
   load with random edges
   ----------------------
*/
for ( ient = 0 ; ient < nentA ; ient++ ) {
   irow = (int) Drand_value(drand) ;
   jcol = (int) Drand_value(drand) ;
   if ( msglvl > 0 ) {
      fprintf(msgFile, "\n loading (%5d,%5d)", irow, jcol) ;
      fflush(msgFile) ;
   }
   DInpMtx_inputEntry(inpmtxA, irow, jcol, 0.0) ;
}
if ( msglvl > 0 ) {
   fprintf(msgFile, "\n\n after loading raw data") ;
   DInpMtx_writeForHumanEye(inpmtxA, msgFile) ;
   fflush(msgFile) ;
}
/*
   ----------------------------------------
   sort, compress and change to vector form
   ----------------------------------------
*/
DInpMtx_sortAndCompress(inpmtxA) ;
if ( msglvl > 0 ) {
   fprintf(msgFile, "\n\n after sort and compress") ;
   DInpMtx_writeForHumanEye(inpmtxA, msgFile) ;
   fflush(msgFile) ;
}
DInpMtx_convertToVectors(inpmtxA) ;
if ( msglvl > 0 ) {
   fprintf(msgFile, "\n\n after convert to vectors") ;
   DInpMtx_writeForHumanEye(inpmtxA, msgFile) ;
   fflush(msgFile) ;
}
/*
   -----------------------------------
   initialize the DInpMtx object for B
   -----------------------------------
*/
inpmtxB = DInpMtx_new() ;
DInpMtx_init(inpmtxB, 1, 1, nentB, nvtx) ;
/*
   ----------------------
   load with random edges
   ----------------------
*/
for ( ient = 0 ; ient < nentB ; ient++ ) {
   irow = (int) Drand_value(drand) ;
   jcol = (int) Drand_value(drand) ;
   if ( msglvl > 0 ) {
      fprintf(msgFile, "\n loading (%5d,%5d)", irow, jcol) ;
      fflush(msgFile) ;
   }
   DInpMtx_inputEntry(inpmtxB, irow, jcol, 0.0) ;
}
if ( msglvl > 0 ) {
   fprintf(msgFile, "\n\n after loading raw data") ;
   DInpMtx_writeForHumanEye(inpmtxB, msgFile) ;
   fflush(msgFile) ;
}
/*
   ----------------------------------------
   sort, compress and change to vector form
   ----------------------------------------
*/
DInpMtx_sortAndCompress(inpmtxB) ;
if ( msglvl > 0 ) {
   fprintf(msgFile, "\n\n after sort and compress") ;
   DInpMtx_writeForHumanEye(inpmtxB, msgFile) ;
   fflush(msgFile) ;
}
DInpMtx_convertToVectors(inpmtxB) ;
if ( msglvl > 0 ) {
   fprintf(msgFile, "\n\n after convert to vectors") ;
   DInpMtx_writeForHumanEye(inpmtxB, msgFile) ;
   fflush(msgFile) ;
}
/*
   ---------------------------------------------------
   get the full adjacency structure of (A+B) + (A+B)^T
   ---------------------------------------------------
*/
fprintf(msgFile, "\n inpmtxA = %p, inpmtxB = %p", inpmtxA, inpmtxB) ;
adjIVL = DInpMtx_fullAdjacency2(inpmtxA, inpmtxB) ;
if ( msglvl > 0 ) {
   fprintf(msgFile, "\n\n full adjacency IVL object") ;
   IVL_writeForHumanEye(adjIVL, msgFile) ;
   fflush(msgFile) ;
}

fprintf(msgFile, "\n") ;
fclose(msgFile) ;

return ; }

/*--------------------------------------------------------------------*/
