/*  testFullAdj.c  */

#include "../DInpMtx.h"
#include "../../Drand.h"

/*--------------------------------------------------------------------*/

void
main ( int argc, char *argv[] )
/*
   ---------------------------------------------------
   generate a random DInpMtx object for a matrix A and
   return an IVL object with the structure of A + A^T

   created -- 97nov05, cca
   ---------------------------------------------------
*/
{
Drand     *drand ;
int       msglvl, ient, irow, jcol, nent, nvtx, rc, seed ;
DInpMtx   *inpmtxA ;
FILE      *msgFile ;
IVL       *adjIVL ;

if ( argc != 6 ) {
   fprintf(stdout, 
      "\n\n usage : testFullAdj msglvl msgFile nvtx nent seed"
      "\n    msglvl  -- message level"
      "\n    msgFile -- message file"
      "\n    nvtx    -- number of rows and columns"
      "\n    nent    -- bound on number of entries"
      "\n    seed    -- random number seed"
      "\n") ;
   return ;
}
msglvl = atoi(argv[1]) ;
if ( strcmp(argv[2], "stdout") == 0 ) {
   msgFile = stdout ;
} else if ( (msgFile = fopen(argv[2], "a")) == NULL ) {
   fprintf(stderr, "\n fatal error in %s"
           "\n unable to open file %s\n",
           argv[0], argv[2]) ;
   return ;
}
nvtx = atoi(argv[3]) ;
nent = atoi(argv[4]) ;
seed = atoi(argv[5]) ;
fprintf(msgFile, 
        "\n testIO "
        "\n msglvl   -- %d" 
        "\n msgFile  -- %s" 
        "\n nvtx     -- %d" 
        "\n nent     -- %d" 
        "\n seed     -- %d" 
        "\n",
        msglvl, argv[2], nvtx, nent, seed) ;
fflush(msgFile) ;
/*
   --------------------------------------
   initialize the random number generator
   --------------------------------------
*/
drand = Drand_new() ;
Drand_setSeed(drand, seed) ;
Drand_setUniform(drand, 0, nvtx) ;
/*
   -----------------------------------
   initialize the DInpMtx object for A
   -----------------------------------
*/
inpmtxA = DInpMtx_new() ;
DInpMtx_init(inpmtxA, 1, 1, nent, nvtx) ;
/*
   ----------------------
   load with random edges
   ----------------------
*/
for ( ient = 0 ; ient < nent ; ient++ ) {
   irow = (int) Drand_value(drand) ;
   jcol = (int) Drand_value(drand) ;
   if ( msglvl > 0 ) {
      fprintf(msgFile, "\n loading (%5d,%5d)", irow, jcol) ;
      fflush(msgFile) ;
   }
   DInpMtx_inputEntry(inpmtxA, irow, jcol, 0.0) ;
}
if ( msglvl > 0 ) {
   fprintf(msgFile, "\n\n after loading raw data") ;
   DInpMtx_writeForHumanEye(inpmtxA, msgFile) ;
   fflush(msgFile) ;
}
/*
   ----------------------------------------
   sort, compress and change to vector form
   ----------------------------------------
*/
DInpMtx_sortAndCompress(inpmtxA) ;
if ( msglvl > 0 ) {
   fprintf(msgFile, "\n\n after sort and compress") ;
   DInpMtx_writeForHumanEye(inpmtxA, msgFile) ;
   fflush(msgFile) ;
}
DInpMtx_convertToVectors(inpmtxA) ;
if ( msglvl > 0 ) {
   fprintf(msgFile, "\n\n after convert to vectors") ;
   DInpMtx_writeForHumanEye(inpmtxA, msgFile) ;
   fflush(msgFile) ;
}
/*
   -------------------------------------------
   get the full adjacency structure of A + A^T
   -------------------------------------------
*/
adjIVL = DInpMtx_fullAdjacency(inpmtxA) ;
if ( msglvl > 0 ) {
   fprintf(msgFile, "\n\n full adjacency IVL object") ;
   IVL_writeForHumanEye(adjIVL, msgFile) ;
   fflush(msgFile) ;
}

fprintf(msgFile, "\n") ;
fclose(msgFile) ;

return ; }

/*--------------------------------------------------------------------*/
