/*  testSplit.c  */

#include "../DInpMtx.h"
#include "../../ETree.h"
#include "../../timings.h"

/*--------------------------------------------------------------------*/

void
main ( int argc, char *argv[] )
/*
   ------------------------------------------------------------
   test the map-to-fronts routine.
   (1) read in a DInpMtx object
   (2) read in an Etree object
   (3) read in an old-to-new IV object
   (4) read in an owners IV object
   (5) permute the DInpMtx object into the new ordering
   (7) split the DInpMtx object into separate objects,
       one for each thread

   created -- 97mar01, cca
   ------------------------------------------------------------
*/
{
char      *buffer, *inDInpMtxFile, *inETreeFile, *inOldToNewIVfile, 
          *inOwnersIVfile ;
DInpMtx   *inpmtx, *newmtx ;
double    t1, t2   ;
ETree     *etree   ;
FILE      *msgFile ;
int       front, ithread, msglvl, nthread, nvtx, rc, v ;
int       *owners, *vtxOldToNew, *vtxToFront ;
IV        *idsIV, *ownersIV, *vtxOldToNewIV ;

if ( argc != 7 ) {
   fprintf(stdout, 
      "\n\n usage : %s msglvl msgFile inDInpMtxFile inETreeFile"
      "\n         inOldToNewIVfile inOwnersFile "
      "\n    msglvl           -- message level"
      "\n    msgFile          -- message file"
      "\n    inDInpMtxFile    -- input DInpMtx file"
      "\n    inETreeFile      -- Etree file"
      "\n    inOldToNewIVfile -- vertex old-to-new permutation IV file"
      "\n    inOwnersIVfile   -- owners IV file"
      "\n", argv[0]) ;
   return ;
}
msglvl = atoi(argv[1]) ;
if ( strcmp(argv[2], "stdout") == 0 ) {
   msgFile = stdout ;
} else if ( (msgFile = fopen(argv[2], "a")) == NULL ) {
   fprintf(stderr, "\n fatal error in %s"
           "\n unable to open file %s\n",
           argv[0], argv[2]) ;
   return ;
}
inDInpMtxFile    = argv[3] ;
inETreeFile      = argv[4] ;
inOldToNewIVfile = argv[5] ;
inOwnersIVfile   = argv[6] ;
fprintf(msgFile, 
        "\n %s "
        "\n msglvl            -- %d" 
        "\n msgFile           -- %s" 
        "\n inDInpMtxFile     -- %s"
        "\n inETreeFile       -- %s"
        "\n inOldToNewIVfile  -- %s"
        "\n inOwnersIVfile    -- %s"
        "\n",
        argv[0], msglvl, argv[2], inDInpMtxFile, inETreeFile,
        inOldToNewIVfile, inOwnersIVfile) ;
fflush(msgFile) ;
/*
   --------------------------
   read in the DInpMtx object
   --------------------------
*/
if ( strcmp(inDInpMtxFile, "none") == 0 ) {
   fprintf(msgFile, "\n no file to read from") ;
   exit(0) ;
}
inpmtx = DInpMtx_new() ;
MARKTIME(t1) ;
rc = DInpMtx_readFromFile(inpmtx, inDInpMtxFile) ;
MARKTIME(t2) ;
fprintf(msgFile, "\n CPU %9.5f : read in inpmtx from file %s",
        t2 - t1, inDInpMtxFile) ;
if ( rc != 1 ) {
   fprintf(msgFile, 
           "\n return value %d from DInpMtx_readFromFile(%p,%s)",
           rc, inpmtx, inDInpMtxFile) ;
   exit(-1) ;
}
fprintf(msgFile, "\n\n after reading DInpMtx object from file %s",
        inDInpMtxFile) ;
if ( msglvl > 2 ) {
   DInpMtx_writeForHumanEye(inpmtx, msgFile) ;
} else {
   DInpMtx_writeStats(inpmtx, msgFile) ;
}
fflush(msgFile) ;
/*
   ------------------------
   read in the ETree object
   ------------------------
*/
if ( strcmp(inETreeFile, "none") == 0 ) {
   fprintf(msgFile, "\n no file to read from") ;
   exit(0) ;
}
etree = ETree_new() ;
MARKTIME(t1) ;
rc = ETree_readFromFile(etree, inETreeFile) ;
MARKTIME(t2) ;
fprintf(msgFile, "\n CPU %9.5f : read in etree from file %s",
        t2 - t1, inETreeFile) ;
if ( rc != 1 ) {
   fprintf(msgFile, "\n return value %d from ETree_readFromFile(%p,%s)",
           rc, etree, inETreeFile) ;
   exit(-1) ;
}
fprintf(msgFile, "\n\n after reading ETree object from file %s",
        inETreeFile) ;
if ( msglvl > 2 ) {
   ETree_writeForHumanEye(etree, msgFile) ;
} else {
   ETree_writeStats(etree, msgFile) ;
}
fflush(msgFile) ;
nvtx       = ETree_nvtx(etree) ;
vtxToFront = ETree_vtxToFront(etree) ;
fprintf(msgFile, "\n %d fronts, %d vertices", etree->nfront, nvtx) ;
/*
   --------------------------------
   read in the old-to-new IV object
   --------------------------------
*/
vtxOldToNewIV = IV_new() ;
MARKTIME(t1) ;
rc = IV_readFromFile(vtxOldToNewIV, inOldToNewIVfile) ;
MARKTIME(t2) ;
fprintf(msgFile, "\n CPU %9.5f : read in vtxOldToNewIV from file %s",
        t2 - t1, inOldToNewIVfile) ;
if ( rc != 1 ) {
   fprintf(msgFile, "\n return value %d from IV_readFromFile(%p,%s)",
           rc, vtxOldToNewIV, inOldToNewIVfile) ;
   exit(-1) ;
}
fprintf(msgFile, "\n\n after reading IV object from file %s",
        inOldToNewIVfile) ;
if ( msglvl > 2 ) {
   IV_writeForHumanEye(vtxOldToNewIV, msgFile) ;
} else {
   IV_writeStats(vtxOldToNewIV, msgFile) ;
}
fflush(msgFile) ;
/*
   ----------------------------
   read in the owners IV object
   ----------------------------
*/
ownersIV = IV_new() ;
MARKTIME(t1) ;
rc = IV_readFromFile(ownersIV, inOwnersIVfile) ;
MARKTIME(t2) ;
fprintf(msgFile, "\n CPU %9.5f : read in ownersIV from file %s",
        t2 - t1, inOwnersIVfile) ;
if ( rc != 1 ) {
   fprintf(msgFile, "\n return value %d from IV_readFromFile(%p,%s)",
           rc, ownersIV, inOwnersIVfile) ;
   exit(-1) ;
}
fprintf(msgFile, "\n\n after reading IV object from file %s",
        inOwnersIVfile) ;
if ( msglvl > 2 ) {
   IV_writeForHumanEye(ownersIV, msgFile) ;
} else {
   IV_writeStats(ownersIV, msgFile) ;
}
fflush(msgFile) ;
owners = IV_entries(ownersIV) ;
/*
   --------------------------
   permute the DInpMtx object
   --------------------------
*/
vtxOldToNew = IV_entries(vtxOldToNewIV) ;
DInpMtx_permute(inpmtx, vtxOldToNew, vtxOldToNew) ;
fprintf(msgFile, "\n permuted DInpMtx object") ;
if ( msglvl > 2 ) {
   DInpMtx_writeForHumanEye(inpmtx, msgFile) ;
} else {
   DInpMtx_writeStats(inpmtx, msgFile) ;
}
/*
   -----------------------------------
   convert to chevrons and vector mode
   -----------------------------------
*/
DInpMtx_changeCoordType(inpmtx, 3) ;
/*
DInpMtx_changeStorageMode(inpmtx, 2) ;
*/
DInpMtx_changeStorageMode(inpmtx, 3) ;
fprintf(msgFile, "\n\n chevrons") ;
if ( msglvl > 2 ) {
   DInpMtx_writeForHumanEye(inpmtx, msgFile) ;
} else {
   DInpMtx_writeStats(inpmtx, msgFile) ;
}
/*
   ------------------------
   split the DInpMtx object
   ------------------------
*/
buffer = CVinit(20, '\0') ;
nthread = 1 + IV_max(ownersIV) ;
idsIV = IV_new() ;
IV_init(idsIV, nvtx, NULL) ;
for ( ithread = 0 ; ithread < nthread ; ithread++ ) {
   IV_setSize(idsIV, 0) ;
   for ( v = 0 ; v < nvtx ; v++ ) {
      front = vtxToFront[v] ;
      if ( owners[front] == ithread ) {
         IV_push(idsIV, v) ;
      }
   }
   newmtx = DInpMtx_extractVectors(inpmtx, idsIV) ;
   fprintf(msgFile, "\n\n matrix for thread %d", ithread) ;
   if ( msglvl > 2 ) {
      DInpMtx_writeForHumanEye(newmtx, msgFile) ;
   } else {
      DInpMtx_writeStats(newmtx, msgFile) ;
   }
   sprintf(buffer, "temp.%d.dinpmtxf", ithread) ;
   DInpMtx_writeToFile(newmtx, buffer) ;
}

fprintf(msgFile, "\n") ;
fclose(msgFile) ;

return ; }

/*--------------------------------------------------------------------*/
