/*  readAIJ.c  */

#include "../DInpMtx.h"

/*--------------------------------------------------------------------*/

void
main ( int argc, char *argv[] )
/*
   ---------------------------------------------------
   read in (i, j, a(i,j)) triples, 
   construct a DInpMtx object and
   write it out to a file

   created -- 97oct17, cca
   ---------------------------------------------------
*/
{
DInpMtx   *inpmtx ;
double    value ;
FILE      *inputFile, *msgFile ;
int       flag, ient, irow, jcol, msglvl, ncol, nent, nrow, rc ;

if ( argc != 6 ) {
   fprintf(stdout, 
      "\n\n usage : readAIJ msglvl msgFile inputFile outFile"
      "\n    msglvl    -- message level"
      "\n    msgFile   -- message file"
      "\n    inputFile -- input file for a(i,j) entries"
      "\n       must have the form"
      "\n       "
      "\n       nrow ncol nentries"
      "\n       irow jcol entry(irow,jcol)"
      "\n       "
      "\n    outFile   -- output file, must be *.dinpmtxf or *.dinpmtxb"
      "\n    flag      -- flag for 0-based or 1-based addressing"
      "\n") ;
   return ;
}
msglvl = atoi(argv[1]) ;
if ( strcmp(argv[2], "stdout") == 0 ) {
   msgFile = stdout ;
} else if ( (msgFile = fopen(argv[2], "a")) == NULL ) {
   fprintf(stderr, "\n fatal error in %s"
           "\n unable to open file %s\n",
           argv[0], argv[2]) ;
   return ;
}
flag = atoi(argv[5]) ;
fprintf(msgFile, 
        "\n readAIJ "
        "\n msglvl    -- %d" 
        "\n msgFile   -- %s" 
        "\n inputFile -- %s" 
        "\n outFile   -- %s" 
        "\n flag      -- %d" 
        "\n",
        msglvl, argv[2], argv[3], argv[4], flag) ;
fflush(msgFile) ;
/*
   ----------------------------
   open the input file and read
   #rows #columns #entries
   ----------------------------
*/
if ( (inputFile = fopen(argv[3], "r")) == NULL ) {
   fprintf(stderr, "\n fatal error in %s"
           "\n unable to open file %s\n",
           argv[0], argv[3]) ;
   return ;
}
rc = fscanf(inputFile, "%d %d %d", &nrow, &ncol, &nent) ;
if ( rc != 3 ) {
   fprintf(stderr, "\n fatal error in %s"
           "\n %d of 3 fields read on first line of file %s",
           argv[0], rc, argv[3]) ;
   return ;
}
if ( msglvl > 1 ) {
   fprintf(msgFile, "\n\n read in nrow = %d, ncol = %d, nent = %d",
           nrow, ncol, nent) ;
   fflush(msgFile) ;
}
/*
   -----------------------------------------
   initialize the object
   set coordType = 1 --> row coordinates
   set inputMode = 2 --> indices and entries
   -----------------------------------------
*/
inpmtx = DInpMtx_new() ;
DInpMtx_init(inpmtx, 1, 2, nent, 0) ;
/*
   -------------------------------------------------
   read in the entries and load them into the object
   -------------------------------------------------
*/
for ( ient = 0 ; ient < nent ; ient++ ) {
   rc = fscanf(inputFile, "%d %d %le", &irow, &jcol, &value) ;
   if ( rc != 3 ) {
      fprintf(stderr, "\n fatal error in %s"
              "\n %d of 3 fields read on entry %d of file %s",
              argv[0], rc, ient, argv[3]) ;
      return ;
   }
   if ( msglvl > 1 ) {
      fprintf(msgFile, "\n entry %d, row %d, column %d, value %e",
              ient, irow, jcol, value) ;
      fflush(msgFile) ;
   }
   if ( flag == 0 ) {
      DInpMtx_inputEntry(inpmtx, irow, jcol, value) ;
   } else {
      DInpMtx_inputEntry(inpmtx, irow-1, jcol-1, value) ;
   }
}
/*
   -----------------------------
   sort and compress the entries
   -----------------------------
*/
DInpMtx_changeStorageMode(inpmtx, 3) ;
if ( msglvl > 1 ) {
   fprintf(msgFile, "\n\n sorted, compressed and vector form") ;
   DInpMtx_writeForHumanEye(inpmtx, msgFile) ;
   fflush(msgFile) ;
}
/*
   ---------------------------
   write out the DInpMtx object
   ---------------------------
*/
if ( strcmp(argv[4], "none") != 0 ) {
   rc = DInpMtx_writeToFile(inpmtx, argv[4]) ;
   fprintf(msgFile, 
           "\n return value %d from DInpMtx_writeToFile(%p,%s)",
           rc, inpmtx, argv[4]) ;
}

fprintf(msgFile, "\n") ;
fclose(msgFile) ;

return ; }

/*--------------------------------------------------------------------*/
