/*  update.c  */

#include "../DFrontMtx.h"

#define MYDEBUG 0

/*--------------------------------------------------------------------*/
/*
   -------------------------------------------------------------
   compute the updates to front J, store them in the DChv object

   created -- 97may13, cca
   -------------------------------------------------------------
*/
void
DFrontMtx_update (
   DFrontMtx   *frontmtx,
   DChv        *frontJ,
   int         head[],
   int         link[],
   int         offsets[],
   DV          *tmpDV,
   int         msglvl,
   FILE        *msgFile
) {
double   *diagent, *lowerent, *upperent ;
int      ierr, ii, iifirst, iilast, I, J, jj, K, ncolI, ncolJ, 
         ndiagent, nDI, nlowerent, npivot, nupperent ;
int      *colindI, *colindJ, *lowerind, *pivotsizes, 
         *sizesL, *sizesU, *upperind, *vtxToFront ;
/*
   ----------------------
   set up data structures
   ----------------------
*/
J = frontJ->id ;
vtxToFront = ETree_vtxToFront(frontmtx->frontETree) ;
/*
   ----------------------------------------
   get the map from global to local indices
   ----------------------------------------
*/
IVL_listAndSize(frontmtx->symbfacIVL, J, &ncolJ, &colindJ) ;

if ( msglvl > 3 ) {
   fprintf(msgFile, "\n\n inside DFrontMtx_update for front %d", J) ;
   fprintf(msgFile, "\n colindJ, ncolJ = %d", ncolJ) ;
   IVfp80(msgFile, ncolJ, colindJ, 80, &ierr) ;
   fflush(msgFile) ;
}
/*
   ----------------------------------
   loop over the fronts that update J
   ----------------------------------
*/
while ( (I = head[J]) != -1 ) {
   if ( msglvl > 2 ) {
      fprintf(msgFile, "\n    update from front %d", I) ;
      fflush(msgFile) ;
   }
/*
   ----------------------
   update the linked list
   ----------------------
*/
   head[J] = link[I] ;
   DFrontMtx_columnIndices(frontmtx, I, &ncolI, &colindI) ;
   if ( msglvl > 3 ) {
      fprintf(msgFile, "\n colindI") ;
      IVfp80(msgFile, ncolI, colindI, 80, &ierr) ;
      fflush(msgFile) ;
   }
   for ( ii = iifirst = offsets[I] ; ii < ncolI ; ii++ ) {
      if ( (K = vtxToFront[colindI[ii]]) != J ) {
         if ( msglvl > 2 ) {
            fprintf(msgFile, "\n    linking front %d to %d, head = %d", 
                    I, K, head[K]) ;
            fflush(msgFile) ;
         }
         link[I]    = head[K] ;
         head[K]    = I  ;
         offsets[I] = ii ;
         break ;
      }
   }
   iilast = ii - 1 ;
/*
   -----------------
   get the local map
   -----------------
*/
   for ( ii = iifirst, jj = 0 ; ii < ncolI ; ii++ ) {
      while ( colindI[ii] != colindJ[jj] ) {
         jj++ ;
      }
      colindI[ii] = jj ;
   }
   if ( msglvl > 3 ) {
      fprintf(msgFile, "\n local map") ;
      IVfp80(msgFile, ncolI, colindI, 80, &ierr) ;
      fflush(msgFile) ;
   }
/*
   ---------------------------
   get pointers to the entries
   ---------------------------
*/
   nDI = DFrontMtx_frontSize(frontmtx, I) ;
   if ( msglvl > 3 ) {
      fprintf(msgFile, "\n nDI = %d", nDI) ;
      fflush(msgFile) ;
   }
   if ( nDI <= 0 ) {
      fprintf(stderr, "\n fatal error, J = %d, I = %d, nDI = %d",
              J, I, nDI) ;
      fflush(msgFile) ;
   }
   DFrontMtx_diagEntries(frontmtx, I, &ndiagent, &diagent) ;
   DFrontMtx_upperEntries(frontmtx, I, &nupperent, &upperent) ;
   if ( msglvl > 3 ) {
      fprintf(msgFile, "\n diag entries") ;
      DVfprintf(msgFile, ndiagent, diagent) ;
      fprintf(msgFile, "\n upper entries") ;
      DVfprintf(msgFile, nupperent, upperent) ;
      fflush(msgFile) ;
   }
   if ( frontmtx->symmetryflag == 0 && frontmtx->pivotingflag == 1 ) {
      DFrontMtx_pivotsizes(frontmtx, I, &npivot, &pivotsizes) ;
   } else {
      npivot = 0 ;
      pivotsizes = NULL ;
   }
/*
   --------------------------
   switch over the four cases
   --------------------------
*/
   if ( frontmtx->sparsityflag == 0 ) {
      if ( frontmtx->symmetryflag == 0 ) {
         if ( msglvl > 3 ) {
            fprintf(msgFile, "\n calling denseSymUpd") ;
            fflush(msgFile) ;
         }
         DChv_denseSymmetricUpdate3(frontJ, nDI, ncolI, 
            npivot, pivotsizes, diagent, upperent, 
            colindI, iifirst, iilast, tmpDV) ;
         if ( msglvl > 3 ) {
            fprintf(msgFile, "\n afterward") ;
            DChv_writeForHumanEye(frontJ, msgFile) ;
            fflush(msgFile) ;
         }
      } else {
         if ( msglvl > 3 ) {
            fprintf(msgFile, "\n calling denseNonsymUpd") ;
            fflush(msgFile) ;
         }
         DFrontMtx_lowerEntries(frontmtx, I, &nlowerent, &lowerent) ;
         DChv_denseNonsymmetricUpdate2(frontJ, nDI, ncolI, diagent, 
            lowerent, upperent, colindI, iifirst, iilast, tmpDV) ;
         if ( msglvl > 3 ) {
            fprintf(msgFile, "\n afterward") ;
            fflush(msgFile) ;
            DChv_writeForHumanEye(frontJ, msgFile) ;
            fflush(msgFile) ;
         }
      }
   } else {
      DFrontMtx_upperSparsityInfo(frontmtx, I, 
                                  &ncolI, &sizesU, &upperind) ;
      if ( frontmtx->symmetryflag == 0 ) {
         if ( msglvl > 3 ) {
            fprintf(msgFile, "\n calling sparseSymUpd") ;
            fflush(msgFile) ;
         }
         DChv_sparseSymmetricUpdate(frontJ, nDI, ncolI, npivot, 
            pivotsizes, diagent, sizesU, upperind, upperent, 
            colindI, iifirst, iilast, tmpDV) ;
         if ( msglvl > 3 ) {
            fprintf(msgFile, "\n afterward") ;
            DChv_writeForHumanEye(frontJ, msgFile) ;
            fflush(msgFile) ;
         }
      } else {
         DFrontMtx_lowerEntries(frontmtx, I, &nlowerent, &lowerent) ;
         DFrontMtx_lowerSparsityInfo(frontmtx, I, 
                                     &ncolI, &sizesL, &lowerind) ;
         if ( msglvl > 3 ) {
            fprintf(msgFile, "\n calling sparseNonsymUpd") ;
            fflush(msgFile) ;
         }
         DChv_sparseNonsymmetricUpdate(frontJ, nDI, ncolI, diagent, 
            sizesL, lowerind, lowerent, sizesU, upperind, upperent, 
            colindI, iifirst, iilast, tmpDV) ;
         if ( msglvl > 3 ) {
            fprintf(msgFile, "\n afterward") ;
            DChv_writeForHumanEye(frontJ, msgFile) ;
            fflush(msgFile) ;
         }
      }
   }
/*
   ---------------------
   restore the local map
   ---------------------
*/
   for ( ii = iifirst ; ii < ncolI ; ii++ ) {
      colindI[ii] = colindJ[colindI[ii]] ;
   }
   if ( msglvl > 3 ) {
      fprintf(msgFile, "\n colindI restored ") ;
      IVfp80(msgFile, ncolI, colindI, 80, &ierr) ;
      fflush(msgFile) ;
   }
}
return ; }

/*--------------------------------------------------------------------*/
