/*  postProcess.c  */

#include "../DFrontMtx.h"

#define MYDEBUG 0

/*--------------------------------------------------------------------*/
/*
   ----------------------------------------------------------
   purpose -- postprocess the DFrontMtx object

   permuteflag == 1 --> used when pivoting enabled
     (1) permute the columns of U_{J,bnd{J}} so they are in
         ascending order w.r.t. to global column numbering
     (2) permute the rows of L_{bnd{J},J} so they are in
         ascending order w.r.t. to global row numbering
   localflag == 0 --> do nothing
   localflag == 1 --> global-to-local,
      overwrite row and column indices bnd{J}
      with indices that are local w.r.t. J's parent
   localflag == 2 --> local-to-global,
      overwrite local row and column indices bnd{J}
      with global indices 

   created -- 97nov20, cca
   ----------------------------------------------------------
*/
void
DFrontMtx_postProcess (
   DFrontMtx   *frontmtx,
   int         permuteflag,
   int         localflag,
   int         msglvl,
   FILE        *msgFile
) {
/*
   -------------------------------
   switch over the different cases
   -------------------------------
*/
if ( permuteflag == 1 && frontmtx->pivotingflag == 1 ) {
/*
   ----------------------------------------------------------------
   permute U (and L if nonsymmetric) to have columns (and rows) in
   ascending order w.r.t. the final global column (and row) indices
   ----------------------------------------------------------------
*/
   DFrontMtx_permuteFactor(frontmtx, msglvl, msgFile) ;
}
if ( localflag == 1 ) {
/*
   ---------------------------------------
   convert global indices to local indices
   ---------------------------------------
*/
   DFrontMtx_globalToLocalInd(frontmtx, msglvl, msgFile) ;
} else if ( localflag == 2 ) {
/*
   ---------------------------------------
   convert local indices to global indices
   ---------------------------------------
*/
   DFrontMtx_localToGlobalInd(frontmtx, msglvl, msgFile) ;
}

return ; }

/*--------------------------------------------------------------------*/
