/*  localInd.c  */

#include "../DFrontMtx.h"

#define MYDEBUG 0

/*--------------------------------------------------------------------*/
/*
   ---------------------------------------------
   purpose -- 

   overwrite row and column indices bnd{J}
   with indices that are local w.r.t. J's parent

   created -- 97nov20, cca
   ---------------------------------------------
*/
void
DFrontMtx_globalToLocalInd (
   DFrontMtx   *frontmtx,
   int         msglvl,
   FILE        *msgFile
) {
int    J, K, ncolK, nrowK ;
int    *colindK, *map, *par, *rowindK ;
Tree   *tree ;

tree = frontmtx->frontETree->tree ;
par  = tree->par ;
map  = IVinit(frontmtx->neqns, -1) ;
/*
   ---------------------------------------
   convert global indices to local indices
   ---------------------------------------
*/
for ( J = Tree_postOTfirst(tree) ;
      J != -1 ;
      J = Tree_postOTnext(tree, J) ) {
   if ( (K = par[J]) != -1 ) {
      DFrontMtx_columnIndices(frontmtx, K, &ncolK, &colindK) ;
      DFrontMtx_setLocalColumnIndices(frontmtx, J, K, ncolK, colindK,
                                      map, msglvl, msgFile) ;
      if (  frontmtx->pivotingflag == 1
         && frontmtx->symmetryflag == 2 ) {
         DFrontMtx_rowIndices(frontmtx, K, &nrowK, &rowindK) ;
         DFrontMtx_setLocalRowIndices(frontmtx, J, K, nrowK, rowindK,
                                      map, msglvl, msgFile) ;
      }
   }
}
IVfree(map) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   -------------------------------------------------------
   convert global column indices into local column indices

   created -- 97nov21, cca
   -------------------------------------------------------
*/
void
DFrontMtx_setLocalColumnIndices (
   DFrontMtx   *frontmtx,
   int         J,
   int         K,
   int         ncolK,
   int         colindK[],
   int         map[],
   int         msglvl,
   FILE        *msgFile
) {
int   ii, ncolJ, nDJ ;
int   *colindJ ;

nDJ = DFrontMtx_frontSize(frontmtx, J) ;
DFrontMtx_columnIndices(frontmtx, J, &ncolJ, &colindJ) ;
if ( msglvl > 2 ) {
   fprintf(msgFile, "\n\n front %d, nDJ = %d, ncolJ = %d",
           J, nDJ, ncolJ) ;
   fprintf(msgFile, "\n column indices") ;
   IVfprintf(msgFile, ncolJ, colindJ) ;
   fflush(msgFile) ;
}
if ( K != -1 ) {
   if ( msglvl > 2 ) {
      fprintf(msgFile, "\n\n parent front %d, ncolK = %d",
              K, ncolK) ;
      fprintf(msgFile, "\n column indices") ;
      IVfprintf(msgFile, ncolK, colindK) ;
      fflush(msgFile) ;
   }
/*
   -----------------------------------
   overwrite column indices for J with
   indices that are local w.r.t K
   -----------------------------------
*/
   for ( ii = 0 ; ii < ncolK ; ii++ ) {
      map[colindK[ii]] = ii ;
   }
   for ( ii = nDJ ; ii < ncolJ ; ii++ ) {
      colindJ[ii] = map[colindJ[ii]] ;
   }
   if ( msglvl > 2 ) {
      fprintf(msgFile, "\n local column indices for %d", J) ;
      IVfprintf(msgFile, ncolJ, colindJ) ;
      fflush(msgFile) ;
   }
}
return ; }

/*--------------------------------------------------------------------*/
/*
   -------------------------------------------------
   convert global row indices into local row indices

   created -- 97nov21, cca
   -------------------------------------------------
*/
void
DFrontMtx_setLocalRowIndices (
   DFrontMtx   *frontmtx,
   int         J,
   int         K,
   int         nrowK,
   int         rowindK[],
   int         map[],
   int         msglvl,
   FILE        *msgFile
) {
int   ii, nrowJ, nDJ ;
int   *rowindJ ;

nDJ = DFrontMtx_frontSize(frontmtx, J) ;
DFrontMtx_rowIndices(frontmtx, J, &nrowJ, &rowindJ) ;
if ( msglvl > 2 ) {
   fprintf(msgFile, "\n\n front %d, nDJ = %d, nrowJ = %d",
           J, nDJ, nrowJ) ;
   fprintf(msgFile, "\n row indices") ;
   IVfprintf(msgFile, nrowJ, rowindJ) ;
   fflush(msgFile) ;
}
if ( K != -1 ) {
   if ( msglvl > 2 ) {
      fprintf(msgFile, "\n\n parent front %d, nrowK = %d",
              K, nrowK) ;
      fprintf(msgFile, "\n row indices") ;
      IVfprintf(msgFile, nrowK, rowindK) ;
      fflush(msgFile) ;
   }
/*
   --------------------------------
   overwrite row indices for J with
   indices that are local w.r.t K
   --------------------------------
*/
   for ( ii = 0 ; ii < nrowK ; ii++ ) {
      map[rowindK[ii]] = ii ;
   }
   for ( ii = nDJ ; ii < nrowJ ; ii++ ) {
      rowindJ[ii] = map[rowindJ[ii]] ;
   }
   if ( msglvl > 2 ) {
      fprintf(msgFile, "\n local row indices for %d", J) ;
      IVfprintf(msgFile, nrowJ, rowindJ) ;
      fflush(msgFile) ;
   }
}
return ; }

/*--------------------------------------------------------------------*/
