/*  loadEntries2.c  */

#include "../DFrontMtx.h"

/*--------------------------------------------------------------------*/
/*
   ------------------------------------------------------------
   load entries from sigma*A

   chv     -- pointer to the DChv object that holds the front
   pencil  -- pointer to a DPencil that holds the matrix entries 
   msglvl  -- message level
   msgFile -- message file

   created  -- 97jul18, cca
   ------------------------------------------------------------
*/
void
DFrontMtx_loadEntries (
   DChv      *chv,
   DPencil   *pencil,
   int       msglvl,
   FILE      *msgFile
) {
DInpMtx   *inpmtxA, *inpmtxB ;
double    sigma ;
double    *chvent ;
int       chvsize, ichv, ncol, nD, nL, nU ;
int       *chvind, *colind ;
/*
   ---------------
   check the input
   ---------------
*/
if ( chv == NULL || (msglvl > 0 && msgFile == NULL) ) {
   fprintf(stderr, 
           "\n fatal error in DFrontMtx_loadEntries2(%p,%p,%d,%p)"
           "\n bad input\n", chv, pencil, msglvl, msgFile) ;
   exit(-1) ;
}
if ( msglvl > 3 ) {
   fprintf(msgFile, 
           "\n\n # inside loadEntries for chv %d", chv->id) ;
   fflush(msgFile) ;
}
DChv_dimensions(chv, &nD, &nL, &nU) ;
DChv_columnIndices(chv, &ncol, &colind) ;
/*
   ----------------------------------------
   load the original entries, A + sigma * B
   ----------------------------------------
*/
inpmtxA = pencil->inpmtxA ;
sigma   = pencil->sigma   ;
inpmtxB = pencil->inpmtxB ;
if ( inpmtxA != NULL ) {
   int   ii ;
/*
   -------------------
   load entries from A
   -------------------
*/
   for ( ii = 0 ; ii < nD ; ii++ ) {
      ichv = colind[ii] ;
      DInpMtx_vector(inpmtxA, ichv, &chvsize, &chvind, &chvent) ;
      if ( chvsize > 0 ) {
         if ( msglvl > 3 ) {
            int ierr ;
            fprintf(msgFile, "\n inpmtxA chevron %d : chvsize = %d", 
                    ichv, chvsize) ;
            fprintf(msgFile, "\n chvind") ;
            IVfp80(msgFile, chvsize, chvind, 80, &ierr) ;
            fprintf(msgFile, "\n chvent") ;
            DVfprintf(msgFile, chvsize, chvent) ;
            fflush(msgFile) ;
         }
         DChv_addChevron(chv, 1.0, ichv, chvsize, chvind, chvent) ;
      }
   }
} else {
   double   *entries ;
   int      ii, off, stride ;
/*
   -----------------
   load the identity
   -----------------
*/
   entries = DChv_entries(chv) ;
   if ( chv->symflag == 0 ) {
      stride = nD + chv->nU ;
      off    = 0 ;
      for ( ii = 0 ; ii < nD ; ii++ ) {
         entries[off] += 1.0 ;
         off += stride ;
         stride-- ;
      }
   } else {
      stride = 2*nD + chv->nL + chv->nU - 2 ;
      off    = nD + chv->nL - 1 ;
      for ( ii = 0 ; ii < nD ; ii++ ) {
         entries[off] += 1.0 ;
         off += stride ;
         stride -= 2 ;
      }
   }
}
if ( inpmtxB != NULL ) {
   int   ii ;
/*
   -------------------------
   load entries from sigma*B
   -------------------------
*/
   for ( ii = 0 ; ii < nD ; ii++ ) {
      ichv = colind[ii] ;
      DInpMtx_vector(inpmtxB, ichv, &chvsize, &chvind, &chvent) ;
      if ( chvsize > 0 ) {
         if ( msglvl > 3 ) {
            int ierr ;
            fprintf(msgFile, "\n inpmtxB chevron %d : chvsize = %d", 
                    ichv, chvsize) ;
            fprintf(msgFile, "\n chvind") ;
            IVfp80(msgFile, chvsize, chvind, 80, &ierr) ;
            fprintf(msgFile, "\n chvent") ;
            DVfprintf(msgFile, chvsize, chvent) ;
            fflush(msgFile) ;
         }
         DChv_addChevron(chv, sigma, ichv, chvsize, chvind, chvent) ;
      }
   }
} else {
   double   *entries ;
   int      ii, off, stride ;
/*
   -----------------
   load the identity
   -----------------
*/
   entries = DChv_entries(chv) ;
   if ( chv->symflag == 0 ) {
      stride = nD + chv->nU ;
      off    = 0 ;
      for ( ii = 0 ; ii < nD ; ii++ ) {
         entries[off] += sigma ;
         off += stride ;
         stride-- ;
      }
   } else {
      stride = 2*nD + chv->nL + chv->nU - 2 ;
      off    = nD + chv->nL - 1 ;
      for ( ii = 0 ; ii < nD ; ii++ ) {
         entries[off] += sigma ;
         off += stride ;
         stride -= 2 ;
      }
   }
}
return ; }

/*--------------------------------------------------------------------*/
