/*  globalInd.c  */

#include "../DFrontMtx.h"

#define MYDEBUG 0

/*--------------------------------------------------------------------*/
/*
   ------------------------------------------------
   purpose -- 

      overwrite local row and column indices bnd{J}
      with global indices 

   created -- 97nov20, cca
   ------------------------------------------------
*/
void
DFrontMtx_localToGlobalInd (
   DFrontMtx   *frontmtx,
   int         msglvl,
   FILE        *msgFile
) {
int    J, K, ncolK, nrowK ;
int    *colindK, *par, *rowindK ;
Tree   *tree ;

tree = frontmtx->frontETree->tree ;
par  = tree->par ;
/*
   ---------------------------------------
   convert local indices to global indices
   ---------------------------------------
*/
for ( J = Tree_preOTfirst(tree) ;
      J != -1 ;
      J = Tree_preOTnext(tree, J) ) {
   if ( (K = par[J]) != -1 ) {
      DFrontMtx_columnIndices(frontmtx, K, &ncolK, &colindK) ;
      DFrontMtx_setGlobalColumnIndices(frontmtx, J, K, ncolK, colindK,
                                      msglvl, msgFile) ;
      if (  frontmtx->pivotingflag == 1
         && frontmtx->symmetryflag == 2 ) {
         DFrontMtx_rowIndices(frontmtx, K, &nrowK, &rowindK) ;
         DFrontMtx_setGlobalRowIndices(frontmtx, J, K, nrowK, rowindK,
                                       msglvl, msgFile) ;
      }
   }
}

return ; }

/*--------------------------------------------------------------------*/
/*
   -------------------------------------------------------
   convert local column indices into global column indices

   created -- 97nov21, cca
   -------------------------------------------------------
*/
void
DFrontMtx_setGlobalColumnIndices (
   DFrontMtx   *frontmtx,
   int         J,
   int         K,
   int         ncolK,
   int         colindK[],
   int         msglvl,
   FILE        *msgFile
) {
int   ii, ncolJ, nDJ ;
int   *colindJ ;

if ( K != -1 ) {
   nDJ = DFrontMtx_frontSize(frontmtx, J) ;
   DFrontMtx_columnIndices(frontmtx, J, &ncolJ, &colindJ) ;
   if ( msglvl > 2 ) {
      fprintf(msgFile, "\n\n front %d, nDJ = %d, ncolJ = %d",
              J, nDJ, ncolJ) ;
      fprintf(msgFile, "\n column indices") ;
      IVfprintf(msgFile, ncolJ, colindJ) ;
      fprintf(msgFile, "\n\n parent front %d, ncolK = %d",
              K, ncolK) ;
      fprintf(msgFile, "\n column indices") ;
      IVfprintf(msgFile, ncolK, colindK) ;
      fflush(msgFile) ;
   }
/*
   --------------------------------------------------
   overwrite column indices for J with global indices
   --------------------------------------------------
*/
   for ( ii = nDJ ; ii < ncolJ ; ii++ ) {
      colindJ[ii] = colindK[colindJ[ii]] ;
   }
   if ( msglvl > 2 ) {
      fprintf(msgFile, "\n global column indices for %d", J) ;
      IVfprintf(msgFile, ncolJ, colindJ) ;
      fflush(msgFile) ;
   }
}
return ; }

/*--------------------------------------------------------------------*/
/*
   -------------------------------------------------
   convert local row indices into global row indices

   created -- 97nov21, cca
   -------------------------------------------------
*/
void
DFrontMtx_setGlobalRowIndices (
   DFrontMtx   *frontmtx,
   int         J,
   int         K,
   int         nrowK,
   int         rowindK[],
   int         msglvl,
   FILE        *msgFile
) {
int   ii, nrowJ, nDJ ;
int   *rowindJ ;

if ( K != -1 ) {
   nDJ = DFrontMtx_frontSize(frontmtx, J) ;
   DFrontMtx_rowIndices(frontmtx, J, &nrowJ, &rowindJ) ;
   if ( msglvl > 2 ) {
      fprintf(msgFile, "\n\n front %d, nDJ = %d, nrowJ = %d",
              J, nDJ, nrowJ) ;
      fprintf(msgFile, "\n row indices") ;
      IVfprintf(msgFile, nrowJ, rowindJ) ;
      fprintf(msgFile, "\n\n parent front %d, nrowK = %d",
              K, nrowK) ;
      fprintf(msgFile, "\n row indices") ;
      IVfprintf(msgFile, nrowK, rowindK) ;
      fflush(msgFile) ;
   }
/*
   --------------------------------------------------
   overwrite row indices for J with global indices
   --------------------------------------------------
*/
   for ( ii = nDJ ; ii < nrowJ ; ii++ ) {
      rowindJ[ii] = rowindK[rowindJ[ii]] ;
   }
   if ( msglvl > 2 ) {
      fprintf(msgFile, "\n global row indices for %d", J) ;
      IVfprintf(msgFile, nrowJ, rowindJ) ;
      fflush(msgFile) ;
   }
}
return ; }

/*--------------------------------------------------------------------*/
