/*  checkFront.c  */

#include "../DFrontMtx.h"
#include "../../timings.h"

#define MYDEBUG 0

/*--------------------------------------------------------------------*/
/*
   -----------------------------------------------
   purpose -- check out and take action on a front

   created -- 97may29, cca
   -----------------------------------------------
*/
char
DFrontMtx_checkFront (
   DFrontMtx     *frontmtx,
   DFactorData   *data,
   int           J,
   int           lookahead,
   char          status[],
   char          willUpdate[],
   int           nactiveChild[],
   int           head[],
   int           link[],
   int           offsets[],
   IV            *pivotsizesIV,
   IV            *markIV,
   DV            *tmpDV
) {
DChv     *chv, *frontJ, *headchv, *postponedchv ;
double   t1, t2 ;
double   *cpus ;
FILE     *msgFile ;
int      frontIsDone, K, msglvl, nbytes, nD, ndelay, nelim, 
         nL, npost, nU ;
int      *owners ;

if ( data->msglvl > 1 ) {
   fprintf(data->msgFile, "\n\n inside checkfront, J = %d, status = %c",
           J, status[J]) ;
   fprintf(data->msgFile, "\n willUpdate = %p", willUpdate) ;
   fflush(data->msgFile) ;
}
cpus     = data->cpus     ;
owners   = IV_entries(data->ownersIV) ;
msglvl   = data->msglvl   ;
msgFile  = data->msgFile  ;
if ( status[J] == 'W' ) {
   if ( data->msglvl > 1 ) {
      fprintf(data->msgFile, "\n willUpdate[%d] = %c",
              J, willUpdate[J]) ;
      fflush(data->msgFile) ;
   }
   if ( willUpdate[J] == 'Y' ) {
/*
      -----------------
      wake up the front
      -----------------
*/
      MARKTIME(t1) ;
      DFrontMtx_initialFrontDimensions(frontmtx, J,
                                       &nD, &nL, &nU, &nbytes) ;
      frontJ = DChvManager_newObjectOfSizeNbytes(data->manager, nbytes);
      if ( frontmtx->symmetryflag == 2 ) {
         DChv_init(frontJ, J, nD, nL, nU, 2) ;
      } else {
         DChv_init(frontJ, J, nD, nL, nU, 0) ;
      }
      if ( data->msglvl > 1 ) {
         fprintf(data->msgFile, "\n frontJ = %p", frontJ) ;
         fflush(data->msgFile) ;
      }
      data->fronts[J] = frontJ ;
      MARKTIME(t2) ;
      cpus[0] += t2 - t1 ;
      MARKTIME(t1) ;
      DFrontMtx_initializeFront(frontmtx, frontJ, J) ;
      if ( owners[J] == data->myid ) {
/*
         -------------------------------------------------
         thread owns this front, load the original entries
         -------------------------------------------------
*/
         MARKTIME(t1) ;
         DFrontMtx_loadEntries(frontJ, data->pencil, msglvl, msgFile) ;
         MARKTIME(t2) ;
         cpus[1] += t2 - t1 ;
         if ( data->msglvl > 1 ) {
            fprintf(data->msgFile, "\n original entries loaded") ;
            fflush(data->msgFile) ;
         }
      }
      if ( data->msglvl > 1 ) {
         fprintf(data->msgFile, "\n\n front initialized") ;
         fflush(data->msgFile) ;
      }
      if ( data->msglvl > 3 ) {
         DChv_writeForHumanEye(frontJ, msgFile) ;
         fflush(data->msgFile) ;
      }
      status[J] = 'A' ;
   } else {
/*
      ------------------------------------------
      front is not owned and will not be updated
      ------------------------------------------
*/
      if ( nactiveChild[J] == 0 ) {
/*
         ----------------------------------------------------
         all children are finished, change status to finished
         ----------------------------------------------------
*/
         status[J] = 'F' ;
      }
   }
}
if ( msglvl > 2 ) {
   fprintf(msgFile, "\n\n now status[%d] = %c", J, status[J]) ;
   fflush(msgFile) ;
}
if ( status[J] == 'A' ) {
/*
   ---------------
   front is active
   ---------------
*/
   frontJ = data->fronts[J] ;
   if ( msglvl > 2 ) {
      fprintf(msgFile, "\n status = %c, frontJ = %p", 
              status[J], frontJ) ;
      fflush(msgFile) ;
   }
   if ( msglvl > 2 ) {
      fprintf(msgFile, "\n head = %p", head) ;
      fflush(msgFile) ;
      fprintf(msgFile, "\n head[%d] = %d", J, head[J]) ;
      fflush(msgFile) ;
   }
   if ( head[J] != -1 ) {
/*
      --------------------------------------------
      perform updates from owned descendent fronts
      --------------------------------------------
*/
      if ( msglvl > 1 ) {
         fprintf(msgFile, "\n performing updates") ;
         fflush(msgFile) ;
      }
      MARKTIME(t1) ;
      DFrontMtx_update(frontmtx, frontJ, head, link, offsets, 
                       tmpDV, msglvl, msgFile) ;
      MARKTIME(t2) ;
      cpus[2] += t2 - t1 ;
   }
   if ( msglvl > 2 ) {
      fprintf(msgFile, "\n owners[%d] = %d", J, owners[J]) ;
      fflush(msgFile) ;
   }
   if ( owners[J] != data->myid ) {
/*
      ------------------
      front is not owned
      ------------------
*/
      if ( nactiveChild[J] == 0 ) {
/*
         -------------------------------------------------
         front is not owned and all children are finished,
         put aggregate update front on the aggregate list
         -------------------------------------------------
*/
         if ( msglvl > 1 ) {
            fprintf(msgFile, "\n done with unowned front %3d", J) ;
            fflush(msgFile) ;
         }
         MARKTIME(t1) ;
         DChvList_addObjectToList(data->aggregatelist, frontJ, J) ;
         MARKTIME(t2) ;
#if MYDEBUG > 0
         fprintf(stdout, "\n thread %2d, done with unowned front %3d",
                 data->myid, J) ;
         fflush(stdout) ;
#endif
         cpus[3] += t2 - t1 ;
         status[J] = 'F' ;
      }
   } else {
/*
      -----------------------------------------------------------------
      front is owned, assemble any aggregate updates from other threads
      -----------------------------------------------------------------
*/
/*
      ----------------------------------------------------
      check to see if all aggregates present in their list
      ----------------------------------------------------
*/
      if ( msglvl > 1 ) {
         fprintf(msgFile, "\n aggregate count = %d for front %d",
                 data->aggregatelist->counts[J], J) ;
         fflush(msgFile) ;
      }
      if ( DChvList_isCountZero(data->aggregatelist, J) == 1 ) {
         if ( msglvl > 1 ) {
            fprintf(msgFile, "\n aggregate count is zero") ;
            fflush(msgFile) ;
         }
         frontIsDone = 1 ;
      } else {
         if ( msglvl > 1 ) {
            fprintf(msgFile, "\n count = %d",
                    data->aggregatelist->counts[J]) ;
            fprintf(msgFile, "\n aggregate count is not zero") ;
            fflush(msgFile) ;
         }
         frontIsDone = 0 ;
      }
      if ( DChvList_isListNonempty(data->aggregatelist, J) == 1 ) {
         if ( msglvl > 1 ) {
            fprintf(msgFile, "\n aggregate list is not empty") ;
            fflush(msgFile) ;
         }
/*
         -------------------------------------------------
         assemble any aggregate updates from other threads
         -------------------------------------------------
*/
         MARKTIME(t1) ;
         headchv = DChvList_getList(data->aggregatelist, J) ;
         for ( chv = headchv ; chv != NULL ; chv = chv->next ) {
            DChv_assembleDChv(frontJ, chv) ;
         }
         MARKTIME(t2) ;
         cpus[4] += t2 - t1 ;
         DChvManager_releaseListOfObjects(data->manager, headchv) ;
      }
      if ( msglvl > 1 ) {
         fprintf(msgFile, "\n nactiveChild[%d] = %d, frontIsDone = %d",
                 J, nactiveChild[J], frontIsDone) ;
         fflush(msgFile) ;
      }
      if ( nactiveChild[J] == 0 && frontIsDone == 1 ) {
/*
         ------------------------------------------------------------
         front has received all of its updates, internal and external
         ------------------------------------------------------------
*/
         if (  data->postponedlist != NULL ) {
/*
            ---------------------------------------------
            front is ready to assemble any postponed data
            ---------------------------------------------
*/
            if ( msglvl > 1 ) {
               fprintf(msgFile, "\n postponed count = %d",
                       data->postponedlist->counts[J]) ;
               if ( DChvList_isCountZero(data->postponedlist, J) == 1) {
                  fprintf(msgFile, "\n all postponed data is here") ;
                  fflush(msgFile) ;
               } else {
                  fprintf(msgFile, 
                          "\n still waiting on postponed data") ;
                  fflush(msgFile) ;
               }
            }
            if ( DChvList_isCountZero(data->postponedlist, J) == 1 ) {
               if ( msglvl > 1 ) {
                  fprintf(msgFile, "\n assembling postponed data") ;
                  fflush(msgFile) ;
               }
/*
               ---------------------------
               assemble any postponed data
               ---------------------------
*/
               MARKTIME(t1) ;
               data->fronts[J] 
                   = DFrontMtx_assemblePostponedData(frontmtx, 
                                frontJ, data->postponedlist, 
                                data->manager, &ndelay) ;
               if ( frontJ != data->fronts[J] ) {
                  DChvManager_releaseObject(data->manager, frontJ) ;
               }
               if ( msglvl > 2 ) {
                  DChv   *chv = data->fronts[J] ;
                  int    size, *indices ;
                  fprintf(msgFile, "\n\n front %d after the assembly",
                          J) ;
                  DChv_rowIndices(chv, &size, &indices) ;
                  fprintf(msgFile, "\n row indices") ;
                  IVfprintf(msgFile, size, indices) ;
                  fprintf(msgFile, "\n column indices") ;
                  DChv_rowIndices(chv, &size, &indices) ;
                  IVfprintf(msgFile, size, indices) ;
                  fflush(msgFile) ;
               }
               status[J] = 'R' ;
               MARKTIME(t2) ;
               cpus[5] += t2 - t1 ;
            }
         } else {
/*
            -----------------
            front is complete
            -----------------
*/
            status[J] = 'R' ;
            ndelay = 0 ;
         }
      }
   }
}
if ( msglvl > 1 ) {
   fprintf(msgFile, "\n\n now  status is %c", status[J]) ;
   fflush(msgFile) ;
}
if ( status[J] == 'R' ) {
/*
   ----------------
   factor the front
   ----------------
*/
   frontJ = data->fronts[J] ;
   if ( msglvl > 1 ) {
      fprintf(msgFile, "\n frontJ = %p, ndelay = %d", frontJ, ndelay) ;
      fflush(msgFile) ;
   }
   if ( msglvl > 1 ) {
      DChv_writeForHumanEye(frontJ, msgFile) ;
      fflush(msgFile) ;
   }
   MARKTIME(t1) ;
   nelim = DChv_factor(frontJ, ndelay, frontmtx->pivotingflag,
              pivotsizesIV, markIV, data->tau, &data->stats[1]) ;
   npost = frontJ->nD - nelim ;
   data->stats[2] += npost ;
   if ( pivotsizesIV == NULL ) {
      data->stats[0] += nelim ;
   } else {
      data->stats[0] += IV_size(pivotsizesIV) ;
   }
   if ( msglvl > 1 ) {
      fprintf(msgFile, 
        "\n\n front %d after the factorization, nelim = %d, npost = %d",
        J, nelim, npost) ;
      fflush(msgFile) ;
   }
   if ( msglvl > 2 ) {
      int   size, *indices ;
      DChv_rowIndices(frontJ, &size, &indices) ;
      fprintf(msgFile, "\n row indices") ;
      IVfprintf(msgFile, size, indices) ;
      DChv_rowIndices(frontJ, &size, &indices) ;
      fprintf(msgFile, "\n column indices") ;
      IVfprintf(msgFile, size, indices) ;
      fflush(msgFile) ;
   }
   if ( msglvl > 3 ) {
      DChv_writeForHumanEye(frontJ, msgFile) ;
      fflush(msgFile) ;
   }
   data->stats[2] += npost ;
   MARKTIME(t2) ;
   cpus[6] += t2 - t1 ;
   K = data->parent[J] ;
   if ( nelim > 0 && K != -1 ) {
/*
      -------------------------------------------------------------
      rows and columns have been eliminated, link front with parent
      -------------------------------------------------------------
*/
      link[J] = head[K] ;
      head[K] = J ;
      offsets[J] = frontJ->nD ;
      if ( msglvl > 3 ) {
         fprintf(msgFile, "\n linking front %d to %d, offset = %d",
                 J, K, offsets[J]) ;
         fflush(msgFile) ;
      }
   }
/*
   ---------------------------------
   there are factor entries to store
   ---------------------------------
*/
   if ( msglvl > 1 ) {
      fprintf(msgFile, "\n storing factor data") ;
      fflush(msgFile) ;
   }
   MARKTIME(t1) ;
   frontJ->nD -= npost ;
   frontJ->nL += npost ;
   frontJ->nU += npost ;
   DFrontMtx_storeFront(frontmtx, frontJ, 
                        pivotsizesIV, data->droptol) ;
   frontJ->nD += npost ;
   frontJ->nL -= npost ;
   frontJ->nU -= npost ;
   MARKTIME(t2) ;
   cpus[8] += t2 - t1 ;
   if ( data->postponedlist != NULL ) {
      if ( npost > 0 ) {
/*
         ---------------------------------
         there is postponed data, 
         extract and put on postponed list
         ---------------------------------
*/
         postponedchv = frontJ ;
         if ( msglvl > 2 ) {
            fprintf(msgFile, "\n postponed data for front %d", J) ;
            DChv_writeForHumanEye(postponedchv, msgFile) ;
            fflush(msgFile) ;
         }
      } else {
         postponedchv = NULL ;
      }   
      if ( msglvl > 1 ) {
         fprintf(msgFile, "\n storing postponed data %p", postponedchv);
         fflush(msgFile) ;
      }
      MARKTIME(t1) ;
      DFrontMtx_storePostponedData(frontmtx, postponedchv, npost, K, 
                                   data->postponedlist, data->manager) ;
      MARKTIME(t2) ;
      cpus[7] += t2 - t1 ;
      if ( msglvl > 1 ) {
         if ( K != -1 ) {
            fprintf(msgFile, "\n postponed count now = %d",
                    data->postponedlist->counts[K]) ;
         } else {
            fprintf(msgFile, "\n postponed count now = %d",
                    data->postponedlist->counts[frontmtx->nfront]) ;
         }
      }
   }
/*
   ------------------------------------------------
   release the front and set the status to finished 
   ------------------------------------------------
*/
   DChvManager_releaseObject(data->manager, frontJ) ;
   data->fronts[J] = NULL ;
   status[J] = 'F' ;
   if ( msglvl > 1 ) {
      fprintf(msgFile, "\n now status[%d] = %c", J, status[J]) ;
      fflush(msgFile) ;
   }
#if MYDEBUG > 0
   fprintf(stdout, "\n thread %2d, done with owned front %3d",
           data->myid, J) ;
   fflush(stdout) ;
#endif
}
if ( (K = data->parent[J]) != -1 ) {
   if ( status[J] == 'F' ) {
/*
      -------------------------------------------------
      decrement the active children count of the parent
      -------------------------------------------------
*/
      nactiveChild[K]-- ;
   } else if ( --lookahead >= 0 ) {
/*
      --------------------------
      check out the parent front
      --------------------------
*/
      DFrontMtx_checkFront(frontmtx, data, K, lookahead, status,
                           willUpdate, nactiveChild, head, link, 
                           offsets, pivotsizesIV, markIV, tmpDV) ;
   }
}
return(status[J]) ; }

/*--------------------------------------------------------------------*/
