/*  basics.c  */

#include "../DFrontMtx.h"

#define   MYDEBUG 0

/*--------------------------------------------------------------------*/
/*
   -----------------------
   simplest constructor

   created -- 97may12, cca
   -----------------------
*/
DFrontMtx *
DFrontMtx_new ( 
   void 
) {
DFrontMtx   *frontmtx ;

ALLOCATE(frontmtx, struct _DFrontMtx, 1) ;
DFrontMtx_setDefaultFields(frontmtx) ;

return(frontmtx) ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------
   set the default fields

   created -- 97may12, cca
   -----------------------
*/
void
DFrontMtx_setDefaultFields (
   DFrontMtx   *frontmtx
) {
if ( frontmtx == NULL ) {
   fprintf(stderr, "\n fatal error in DFrontMtx_setDefaultFields(%p)"
           "\n bad input", frontmtx) ;
   exit(-1) ;
}
frontmtx->nfront       =   0  ;
frontmtx->neqns        =   0  ;
frontmtx->symmetryflag =   0  ;
frontmtx->sparsityflag =   0  ;
frontmtx->pivotingflag =   0  ;
frontmtx->frontETree   = NULL ;
frontmtx->symbfacIVL   = NULL ;
frontmtx->frontsizesIV = NULL ;
frontmtx->pivotsIVL    = NULL ;
frontmtx->rowadjIVL    = NULL ;
frontmtx->coladjIVL    = NULL ;
frontmtx->lowerIVL     = NULL ;
frontmtx->upperIVL     = NULL ;
frontmtx->diagDVL      = NULL ;
frontmtx->lowerDVL     = NULL ;
frontmtx->upperDVL     = NULL ;
frontmtx->lock         = NULL ;
frontmtx->nlocks       =   0  ;

return ; }

/*--------------------------------------------------------------------*/
/*
   --------------------------------------------------
   clear the data fields, releasing allocated storage

   created -- 97may12, cca
   --------------------------------------------------
*/
void
DFrontMtx_clearData ( 
   DFrontMtx   *frontmtx 
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( frontmtx == NULL ) {
   fprintf(stderr, "\n fatal error in DFrontMtx_clearData(%p)"
           "\n bad input\n", frontmtx) ;
   exit(-1) ;
}
/*
   ----------------------
   free the owned storage
   ----------------------
*/
if ( frontmtx->frontsizesIV != NULL ) {
   IV_free(frontmtx->frontsizesIV) ;
}
if ( frontmtx->pivotsIVL != NULL ) {
   IVL_free(frontmtx->pivotsIVL) ;
}
if ( frontmtx->rowadjIVL != NULL ) {
   IVL_free(frontmtx->rowadjIVL) ;
}
if ( frontmtx->coladjIVL != NULL ) {
   IVL_free(frontmtx->coladjIVL) ;
}
if ( frontmtx->lowerIVL != NULL ) {
   IVL_free(frontmtx->lowerIVL) ;
}
if ( frontmtx->upperIVL != NULL ) {
   IVL_free(frontmtx->upperIVL) ;
}
if ( frontmtx->diagDVL != NULL ) {
   DVL_free(frontmtx->diagDVL) ;
}
if ( frontmtx->lowerDVL != NULL ) {
   DVL_free(frontmtx->lowerDVL) ;
}
if ( frontmtx->upperDVL != NULL ) {
   DVL_free(frontmtx->upperDVL) ;
}
if ( frontmtx->lock != NULL ) {
/*
   -------------------------
   destroy and free the lock
   -------------------------
*/
   Lock_free(frontmtx->lock) ;
}
/*
   ----------------------
   set the default fields
   ----------------------
*/
DFrontMtx_setDefaultFields(frontmtx) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   ------------------------------------------
   destructor, free's the object and its data

   created -- 97may12, cca
   ------------------------------------------
*/
void
DFrontMtx_free ( 
   DFrontMtx   *frontmtx 
) {
if ( frontmtx == NULL ) {
   fprintf(stderr, "\n fatal error in DFrontMtx_free(%p)"
           "\n bad input\n", frontmtx) ;
   exit(-1) ;
}
DFrontMtx_clearData(frontmtx) ;
FREE(frontmtx) ;

return ; }

/*--------------------------------------------------------------------*/
