/*  QRstoreUpdate.c  */

#include "../DFrontMtx.h"
#include "../../DStairMtx.h"

/*--------------------------------------------------------------------*/
/*
   --------------------------------------------------------------------
   procedure to store the update entries into a Chveron object

   factormtx       -- DA2 object that contains the update matrix
   updatelist      -- DChvList object
   manager         -- DChvManager object
   J               -- front ID
   K               -- parent of J
   nJ              -- number of interior node
   nDU             -- number of interior and exterior nodes
   nupdrow         -- number of update rows
   colsJ           -- column index
   msglvl          -- message level
   msgFile         -- message file

   created -- 97apr17, dkw
   --------------------------------------------------------------------
*/
void
DFrontMtx_QRstoreUpdate (

   DA2           *factormtx,
   DChvList      *updatelist,
   DChvManager   *manager,
   int           J,
   int           K,
   int           nJ,
   int           nDU,
   int           nupdrow,
   int           *colsJ,
   int           msglvl,
   FILE          *msgFile
) {
DChv   *updateJ ;
double *entries ;
int    chvcols, i, nbytes, nD, nent, nL, nU, symflag ;
int    *colind ;
/*
   ---------------
   check the input
   ---------------
*/
if (  factormtx == NULL || updatelist == NULL || manager == NULL
   || (msglvl > 0 && msgFile == NULL) ) {
   fprintf(stderr, 
"\n fatal error in DFrontMtx_QRstoreUpdate(%p,%p,%p,%d,%d,%d,%d,%d,%p,%d,%p)"
"\n bad input\n", factormtx, updatelist, manager, J, K, nJ, nDU, nupdrow,
                  colsJ, msglvl, msgFile) ;
   exit(-1) ;
}
if ( msglvl > 3 ) {
   fprintf(msgFile,  "\n\n ### inside QRstoreUpdate") ;
   fprintf(msgFile,  "\n\n ### no. of update rows = %d",nupdrow) ;
   fflush(msgFile) ;
}
/*
   ---------------------------------------------
   get a new chevron object and store the update
   ---------------------------------------------
*/
if ( nupdrow > 0 ){
   nL = 0 ;
   nD = nupdrow ;
   nU = nDU - nD - nJ ;
   symflag  = 0 ;

   nbytes  = DChv_nbytesNeeded(nD, nL, nU, symflag) ;
   updateJ = DChvManager_newObjectOfSizeNbytes(manager, nbytes) ;
   DChv_init(updateJ, J, nD, nL, nU, symflag) ;

   DChv_columnIndices(updateJ, &chvcols, &colind) ;
   for ( i = 0 ; i < chvcols ; i++ ) {
       colind[i] = colsJ[i+nJ] ;
   }
   entries = DChv_entries(updateJ) ;

   nent = (nD*(nD+1))/2 + nU*nD ;
   DA2_copyEntriesToVector(factormtx, nent, entries, 4, 0) ;
   if ( msglvl > 3 ) {
      fprintf(msgFile, "\n after update entries have been stored") ;
      DChv_writeForHumanEye(updateJ, msgFile) ;
      fflush(msgFile) ;
   }
/*
   --------------------------------------------------
   now put the update chevrons onto the parent list.
   --------------------------------------------------
*/
   if ( K != -1 ) {
      DChvList_addObjectToList(updatelist, updateJ, K) ;
   }
}

if ( msglvl > 3 ) {
   fprintf(msgFile,  "\n leaving QRstoreUpdate ") ;
   fflush(msgFile) ;
}
return ; }

/*--------------------------------------------------------------------*/
