/*  QRstoreFactor.c  */

#include "../DFrontMtx.h"

/*--------------------------------------------------------------------*/
/*
   -------------------------------------------------
   extract the QR factor entries into the frontmtx

   created -- 97may21, dkw
   -------------------------------------------------
*/
void
DFrontMtx_QRstoreFactor (
   DFrontMtx   *frontmtx,
   DA2         *factormtx,
   int         J,
   int         msglvl,
   FILE        *msgFile

) {
double   *diagent, *upperent ;
int      nD, nentD, nentU, nU, totsize ;
int      *frontSizes, *indices ;

/*
   ---------------
   check the input
   ---------------
*/
if ( frontmtx == NULL || J < 0 || J >= frontmtx->nfront
   || factormtx == NULL || (msglvl > 0 && msgFile == NULL) ) {
   fprintf(stderr,
           "\n fatal error in DFrontMtx_QRstoreFactor(%p,%p,%d,%d,%p)"
           "\n bad input\n", frontmtx, factormtx, J, msglvl, msgFile) ;
   exit(-1) ;
}
if ( msglvl > 3 ) {
   fprintf(msgFile,  "\n\n ### inside QRstoreFactor") ;
   fflush(msgFile) ;
}
IVL_listAndSize(frontmtx->symbfacIVL, J, &totsize, &indices) ;
frontSizes   = IV_entries(frontmtx->frontETree->nodwghtsIV) ;
nD  = frontSizes[J] ;
nU  = totsize - nD ;
/*
      ------------------
      store entries in D
      ------------------
*/
nentD = nD ;
DVL_setList(frontmtx->diagDVL, J, nentD, NULL) ;
DFrontMtx_diagEntries(frontmtx, J, &nentD, &diagent) ;
DA2_copyEntriesToVector(factormtx, nentD, diagent, 3, 1) ;
/*
      ------------------
      store entries in U
      ------------------
*/
nentU = (nD*(nD-1))/2 + nD*nU ;
if ( nentU > 0 ){
   DVL_setList(frontmtx->upperDVL, J, nentU, NULL) ;
   DFrontMtx_upperEntries(frontmtx, J, &nentU, &upperent) ;
   DA2_copyEntriesToVector(factormtx, nentU, upperent, 5, 1) ;
}

if ( msglvl > 3 ) {
   fprintf(msgFile,  "\n\n ### leaving QRstoreFactor") ;
   fflush(msgFile) ;
}
return ; }

/*--------------------------------------------------------------------*/
