/*  QRsolve.c  */

#include "../DFrontMtx.h"
#include "../../timings.h"

#define MYDEBUG  0
/*--------------------------------------------------------------------*/
/*
   --------------------------------------------
   solve (U^T + D) * (D + U) sol = rhs
      D is diagonal
   by calling DFrontMtx_solveDA2 providing
   sparsityflag = 0 and symmetryflag = 3
   being initialize earlier in the test driver

   cpus     -- vector of cpu time breakdowns
      cpus[0] -- initialize rhs matrices
      cpus[1] -- load rhs matrices with rhs
      cpus[2] -- assemble from children and parent
      cpus[3] -- solve and update
      cpus[4] -- store entries
      cpus[5] -- link and free matrices
      cpus[6] -- miscellaneous
      cpus[7] -- total time

   created -- 97may27, dkw
   --------------------------------------------
*/
void
DFrontMtx_QRsolve (
   DFrontMtx   *frontmtx,
   DInpMtx     *inpmtxA,
   IV          *newToOldIV,
   DA2         *solDA2,
   DA2         *rhsDA2,
   double      cpus[]
) {
double             *dvec, *rhs, *rhsloc ;
double             cputotal, t1, t2 ;
DA2                *AtranRHS ;
DDenseMtxManager   *manager ;
int                col, ii, jrhs, ncolsol, nent, nrhs, nrowsol, rc, row ;
int                *ivec1, *ivec2, *ivptr ;
/*
   ---------------
   check the input
   ---------------
*/
MARKTIME(t1) ;
if ( frontmtx == NULL || inpmtxA == NULL || newToOldIV == NULL
   || solDA2 == NULL || rhsDA2 == NULL ) {
   fprintf(stderr, "\n fatal error in DFrontMtx_QRsolve(%p,%p,%p,%p,%p,%p)"
           "\n bad input\n", frontmtx, inpmtxA, newToOldIV, solDA2,
                             rhsDA2, cpus) ;
   exit(-1) ;
}
/*
   -----------------------------------
   extract pointers and initialization
   -----------------------------------
*/
rc = DInpMtx_coordType(inpmtxA) ;
if ( rc != 2 ) DInpMtx_changeCoordType(inpmtxA, 2) ;
rc = DInpMtx_storageMode(inpmtxA) ;
if ( rc != 1 ) DInpMtx_changeStorageMode(inpmtxA, 1) ;

manager = DDenseMtxManager_new() ;
DDenseMtxManager_init(manager, 0) ;
/*
   --------------------------
   set up the working storage
   --------------------------
*/
AtranRHS = DA2_new() ;
nrowsol = DA2_nrow(solDA2) ;
ncolsol = DA2_ncol(solDA2) ;
DA2_init(AtranRHS, nrowsol, ncolsol, 1, nrowsol, NULL) ;
DVzero(nrowsol*ncolsol, AtranRHS->entries) ;
/*
   ------------------------------
   replace the rhs with A^T * rhs
   ------------------------------
*/
nrhs  = DA2_ncol(rhsDA2) ;
ivec1 = DInpMtx_ivec1(inpmtxA) ;
ivec2 = DInpMtx_ivec2(inpmtxA) ;
dvec  = DInpMtx_dvec(inpmtxA) ;
nent  = inpmtxA->nent ;
for ( jrhs = 0 ; jrhs < nrhs ; jrhs++ ) {
   rhs    = DA2_column(rhsDA2, jrhs) ;
   rhsloc = DA2_column(AtranRHS, jrhs) ;
   for ( ii = 0 ; ii < nent ; ii++ ) {
       row = ivec1[ii] ;
       col = ivec2[ii] ;
       rhsloc[row] += dvec[ii] * rhs[col] ;
   }
}
#if MYDEBUG > 0
   fprintf(stdout, "\n a transpose rhs :") ;
   DA2_writeForHumanEye(AtranRHS, stdout)  ;
   fflush(stdout) ;
#endif
/*
   -----------------------------------
   solve (U^T + D) * (D + U) sol = rhs
   -----------------------------------
*/
DFrontMtx_solveDA2(frontmtx, solDA2, AtranRHS, manager, cpus) ;
#if MYDEBUG > 0
   fprintf(stdout, "\n after DFrontMtx_solveDA2 - solDA2 :") ;
   DA2_writeForHumanEye(solDA2, stdout)  ;
   fflush(stdout) ;
#endif

/*
   -------------------------------------------
   permute solution back to the original order
   -------------------------------------------
*/
ivptr = IV_entries(newToOldIV) ;
DA2_copy( AtranRHS, solDA2 ) ;
DA2_scatter(solDA2, ivptr, NULL, AtranRHS) ;

#if MYDEBUG > 0
   fprintf(stdout, "\n\n solution in original form - solDA2 ") ;
   DA2_writeForHumanEye(solDA2, stdout)  ;
   fflush(stdout) ;
#endif

/*
   ------------------------
   free the working storage
   ------------------------
*/
DA2_free(AtranRHS) ;
DDenseMtxManager_free(manager) ;
MARKTIME(t2) ;
cputotal = t2 - t1 ;
cpus[6] = cputotal - cpus[7] + cpus[6] ;
cpus[7] = cputotal ;

return ; }
