/*  QRloadEntries.c  */

#include "../DFrontMtx.h"

/*--------------------------------------------------------------------*/
/*
   ------------------------------------------------------------
   load original entries from A

   stairfront -- pointer to the StairMtx object that holds the stairfront
   J          -- front ID
   inpmtxA    -- pointer to a DInpMtx that holds the entries of A
   symbfacIVL -- symbolic factorization IVL
   rowsIVL    -- list of rows in A that goes into each front
   msglvl     -- message level
   msgFile    -- message file

   created -- 97apr09, dkw
   ------------------------------------------------------------
*/
void
DFrontMtx_QRloadEntries (
   DStairMtx *stairfront,
   int       J,
   DInpMtx   *inpmtxA,
   IVL       *symbfacIVL,
   IVL       *rowsIVL,
   int       msglvl,
   FILE      *msgFile
) {
DA2       *stairmtx ;
double    *entries, *frontEntries, *rowJ ;
int       ii, jj, irowA, irowJ, ncolJ, nent, nrowJ ;
int       *colsJ, *indices, *rowsJ ;
/*
   ---------------
   check the input
   ---------------
*/
if ( stairfront == NULL || inpmtxA == NULL || rowsIVL == NULL
   || (msglvl > 0 && msgFile == NULL) ) {
   fprintf(stderr, 
           "\n fatal error in DFrontMtx_QRloadEntries(%p,%d,%p,%p,%d,%p)"
           "\n bad input\n", stairfront, J, inpmtxA, rowsIVL, msglvl, msgFile) ;
   exit(-1) ;
}
if ( msglvl > 2 ) {
   fprintf(msgFile, "\n\n # inside QRloadEntries for front %d", J) ;
   fflush(msgFile) ;
}
/*
   ----------------------------
   set up pointers for stairmtx
   ----------------------------
*/
stairmtx = &stairfront->stairmtx ;
frontEntries = DA2_entries(stairmtx) ;
/*
   -------------------------------
   load entries from A by
   loop over the rows in the front
   -------------------------------
*/
IVL_listAndSize(symbfacIVL, J, &ncolJ, &colsJ) ;
IVL_listAndSize(rowsIVL, J, &nrowJ, &rowsJ) ;

rowJ = frontEntries ;
for ( irowJ = 0 ; irowJ < nrowJ ; irowJ++ ) {
   irowA = rowsJ[irowJ] ;
   DInpMtx_vector(inpmtxA, irowA, &nent, &indices, &entries) ;

   ii = jj = 0 ;
   while ( ii < nent && jj < ncolJ ) {
       if ( indices[ii] == colsJ[jj] ) {
          rowJ[jj] = entries[ii] ;
          ii++, jj++ ;
       }else if ( indices[ii] > colsJ[jj] ) {
          jj++ ;
       }else{
        fprintf(msgFile, "\n ****error inside QRloadEntries mapping") ;
        fprintf(msgFile, "\n ii = %d indices[ii] = %d", ii, indices[ii]) ;
        fprintf(msgFile, "\n jj = %d colsJ[jj] = %d", jj, colsJ[jj]) ;
       }
   }
   rowJ += ncolJ ;
}

if ( msglvl > 3 ) {
   fprintf(msgFile, "\n after entries in A have been loaded") ;
   DA2_writeForHumanEye(stairmtx, msgFile) ;
   fflush(msgFile) ;
}

return ; }

/*--------------------------------------------------------------------*/
