/*  QRfactorFront.c  */

#include "../DFrontMtx.h"
#include "../../DStairMtx.h"

/*--------------------------------------------------------------------*/
/*
   --------------------------------------------------------------------
   procedure to factor a front

   stairfront      -- front DStairMtx object
   J               -- front ID
   facops          -- QR factorization ops. count
   msglvl          -- message level
   msgFile         -- message file

   created -- 97apr17, dkw
   --------------------------------------------------------------------
*/
void
DFrontMtx_QRfactorFront (
   DStairMtx  *stairfront,
   int        J,
   double     *facops,
   int        msglvl,
   FILE       *msgFile
) {
DA2    *stairmtx ;
int    ncols, nJ, nrows ;
int    *lastrowindex ;
/*
   ---------------
   check the input
   ---------------
*/
if (  stairfront == NULL || (msglvl > 0 && msgFile == NULL) ) {
   fprintf(stderr, "\n fatal error in DFrontMtx_QRfactorFront(%p,%d,%p,%d,%p)"
                   "\n bad input\n", stairfront, J, facops, msglvl, msgFile) ;
   exit(-1) ;
}
if ( msglvl > 3 ) {
   fprintf(msgFile,  "\n\n ### inside QRfactorFront") ;
   fflush(msgFile) ;
}
/*
   ----------------------
   initialize the objects
   ----------------------
*/
stairmtx = &stairfront->stairmtx ;
lastrowindex = IV_entries(&stairfront->lastrowIV) ;
ncols    = stairfront->ncol ;
nrows    = stairfront->nrow ;
nJ       = stairfront->nJ   ;

/*
   ----------------------------
   compute the QR factorization
   ----------------------------
*/
if ( nrows > 1 ) {
   DStairMtx_QRfactor(stairmtx, lastrowindex, facops) ;
   if ( msglvl > 4 ) {
      fprintf(msgFile, "\n ### matrix after QR factor") ;
      DA2_writeForHumanEye(stairmtx, msgFile) ;
      fflush(msgFile) ;
   }
}

if ( msglvl > 3 ) {
   fprintf(msgFile,  "\n ### leaving QRfactorFront ") ;
   fflush(msgFile) ;
}
return ; }

/*--------------------------------------------------------------------*/
