/*  QRcheckFront.c  */

#include "../DFrontMtx.h"
#include "../../timings.h"

#define MYDEBUG 0

/*--------------------------------------------------------------------*/
/*
   -----------------------------------------------
   purpose -- check out and take action on a front

   created -- 97aug22, dkw
   -----------------------------------------------
*/
void
DFrontMtx_QRcheckFront (
   DFrontMtx      *frontmtx,
   DQRFactorData  *data,
   int            J,
   char           status[]
) {
DA2      tmpDA2, *factormtx ;
DChv     *childi, *firstchild ;
DStairMtx *stairfrontJ ;
double   opscnt, t1, t2 ;
double   *facops; 
double   *cpus ;
FILE     *msgFile ;
int      K, msglvl, ncolJ, nD, nJ, nrowJ, nupdrow, totsize ;
int      *fchild, *indices, *parent, *sibling ;

/*
   --------------
   initialization
   --------------
*/
facops   = data->facops;
cpus     = data->cpus     ;
msglvl   = data->msglvl   ;
msgFile  = data->msgFile  ;
parent   = frontmtx->frontETree->tree->par ;
fchild   = frontmtx->frontETree->tree->fch ;
sibling  = frontmtx->frontETree->tree->sib ;
K        = parent[J] ;

if ( msglvl > 1 ) {
   fprintf(msgFile, "\n inside QRcheckfront, J = %d, status = %c",
           J, status[J]) ;
   fflush(msgFile) ;
}
if ( DChvList_isCountZero(data->updatelist, J) != 1 ) {
   return ;
}

fprintf(msgFile, " \n j= %d status for J = %c\n", J, status[J]);
/*
   ------------------------
   initialize the DStairMtx
   ------------------------
*/
   MARKTIME(t1) ;
   nJ = frontmtx->frontETree->nodwghtsIV->vec[J] ;
   IVL_listAndSize(frontmtx->symbfacIVL, J, &totsize, &indices) ;
   if ( msglvl > 1 ) {
      fprintf(msgFile,
              "\n\n ### visiting front %d, nJ = %d, nbndJ = %d",
              J, nJ, totsize - nJ) ;
      fflush(msgFile) ;
   }
   nrowJ = data->rowsIVL->sizes[J] ;
   ncolJ = totsize ;

   firstchild = DChvList_getList(data->updatelist, J) ;
   if ( fchild[J] != -1 ) {
      for ( childi = firstchild ; childi != NULL ; childi = childi->next ) {
          nD = childi->nD ;
          nrowJ += nD ;
      }
   }
   stairfrontJ = DStairMtx_new() ;
   DStairMtx_init(stairfrontJ, J, nrowJ, ncolJ, nJ) ;

   MARKTIME(t2) ;
   cpus[0] += t2 - t1 ;

/*
   -------------------------------------------------
   thread owns this front, load the original entries
   -------------------------------------------------
*/
   MARKTIME(t1) ;
   DFrontMtx_QRloadEntries(stairfrontJ, J, data->inpmtxA, frontmtx->symbfacIVL,
                           data->rowsIVL, msglvl, msgFile) ;
   MARKTIME(t2) ;
   cpus[1] += t2 - t1 ;
   status[J] = 'A' ;
   if ( msglvl > 2 ) {
      fprintf(msgFile, " \n after QRloadEntries for J = %d\n", J);
      fprintf(msgFile, "\n now status[%d] = %c", J, status[J]) ;
      fflush(msgFile) ;
   }
/*
   -------------------------------------
   assemble updates from children fronts
   -------------------------------------
*/
   MARKTIME(t1) ;
   if ( firstchild != NULL ) {
      DFrontMtx_QRassembleUpdates(stairfrontJ, J, frontmtx->symbfacIVL,
                                  data->rowsIVL, data->manager,
                                  firstchild, msglvl, msgFile) ;
   }
   MARKTIME(t2) ;
   cpus[2] += t2 - t1 ;
   if ( msglvl > 2 ) {
      fprintf(msgFile, " \n after QRassembleUpdates for J = %d\n", J);
      fflush(msgFile) ;
   }
/*
   -----------------------------
   form staircase and lastrowIVL
   -----------------------------
*/
   MARKTIME(t1) ;
   DStairMtx_formStaircase(stairfrontJ, msglvl, msgFile) ;
   MARKTIME(t2) ;
   cpus[3] += t2 - t1 ;
   if ( msglvl > 2 ) {
      fprintf(msgFile, " \n after formStaircase for J = %d\n", J);
      DStairMtx_writeForHumanEye(stairfrontJ, msgFile) ;
      fflush(msgFile) ;
   }
/*
   ----------------
   factor the front
   ----------------
*/
   MARKTIME(t1) ;
   DFrontMtx_QRfactorFront(stairfrontJ, J, &opscnt, msglvl, msgFile) ;
   *facops += opscnt ;
   MARKTIME(t2) ;
   cpus[4] += t2 - t1 ;
   if ( msglvl > 2 ) {
      fprintf(msgFile, "\n\n after QRfactorFront" ) ;
      fflush(msgFile) ;
   }
/*
   -----------------------
   store the update matrix
   -----------------------
*/
   MARKTIME(t1) ;
   factormtx = &tmpDA2 ;
   nupdrow = stairfrontJ->nupdrow ;
   DA2_subDA2(factormtx, &stairfrontJ->stairmtx, nJ, nJ+nupdrow-1,
              nJ, totsize-1) ;
   DFrontMtx_QRstoreUpdate(factormtx, data->updatelist, data->manager, J, K, nJ,
                           totsize, nupdrow, indices, msglvl, msgFile) ;
   MARKTIME(t2) ;
   cpus[5] += t2 - t1 ;
   if ( msglvl > 2 ) {
      fprintf(msgFile, "\n finished storing update for front = %d\n", J) ;
      fflush(msgFile) ;
   }
/*
   -------------------
   store the QR factor
   -------------------
*/
   MARKTIME(t1) ;
   DA2_subDA2(factormtx, &stairfrontJ->stairmtx, 0, nJ-1, 0, totsize-1) ;
   DFrontMtx_QRstoreFactor(frontmtx, factormtx, J, msglvl, msgFile) ;
   MARKTIME(t2) ;
   cpus[6] += t2 - t1 ;
   if ( msglvl > 2 ) {
      fprintf(msgFile, "\n finished storing entries for front = %d\n", J) ;
      fflush(msgFile) ;
   }
/*
   -------------------
   free the stairfront
   -------------------
*/
   DStairMtx_free(stairfrontJ) ;
/*
   ------------------------------------------------
   release the front and set the status to finished 
   ------------------------------------------------
*/
status[J] = 'F' ;
if ( msglvl > 1 ) {
   fprintf(msgFile, "\n now status[%d] = %c", J, status[J]) ;
   fflush(msgFile) ;
}

#if MYDEBUG > 0
   fprintf(stdout, "\n thread %2d, done with owned front %3d",
           data->myid, J) ;
   fflush(stdout) ;
#endif
return ; }

/*--------------------------------------------------------------------*/
