/*  assembleUpdates.c  */

#include "../DFrontMtx.h"

#define MYDEBUG 0

static void
DChv_scatterToDA2 ( DChv   *chvI, DA2    *mtxJ, int    colindJ[]) ;
/*--------------------------------------------------------------------*/
/*
   -------------------------------------------------------------
   purpose -- given a stairfront that has had its original
      entries assembled, incorporate any updates from its
      children fronts.

   created -- 97apr16, dkw
   -------------------------------------------------------------
*/
void
DFrontMtx_QRassembleUpdates (
   DStairMtx     *stairfrontJ,
   int           J,
   IVL           *symbfacIVL,
   IVL           *rowsIVL,
   DChvManager   *manager,
   DChv          *firstchild,
   int           msglvl,
   FILE          *msgFile
) {
DA2        tmpDA2 ;
DA2        *mtxJ, *stairmtx ;
DChv       *childi ;
int        ncolJ, nD, nrowJ ;
int        *colsJ ;
/*
   ---------------
   check the input
   ---------------
*/
if ( stairfrontJ == NULL || symbfacIVL == NULL || rowsIVL == NULL
   || (msglvl > 0 && msgFile == NULL) ) {
   fprintf(stderr, 
       "\n fatal error in DFrontMtx_QRassembleUpdates(%p,%d,%p,%p,%p,%p,%d,%p)"
       "\n bad input\n", stairfrontJ, J, symbfacIVL, rowsIVL,
                         manager, firstchild, msglvl, msgFile) ;
   exit(-1) ;
}
if ( msglvl > 2 ) {
   fprintf(msgFile, 
           "\n\n ### inside QRassembleUpdates for stairfront %d", J) ;
   fflush(msgFile) ;
}
/*
  --------------------------------------
  set up pointers for current stairfront
  --------------------------------------
*/
stairmtx = &stairfrontJ->stairmtx ;
nrowJ    = rowsIVL->sizes[J] ;
DA2_setDefaultFields(&tmpDA2) ;
mtxJ = &tmpDA2 ;
IVL_listAndSize(symbfacIVL, J, &ncolJ, &colsJ) ;

/*
   ----------------------------
   process update from children
   ----------------------------
*/

for ( childi = firstchild ; childi != NULL ; childi = childi->next ) {
    nD = childi->nD ;
    DA2_subDA2(mtxJ, stairmtx, nrowJ, nrowJ+nD-1, 0, ncolJ-1) ;
    DChv_scatterToDA2(childi, mtxJ, colsJ) ;

    if ( msglvl > 3 ) {
       fprintf(msgFile, "\n  finished update for child =%d ", childi->id) ;
       fflush(msgFile) ;
    }
    nrowJ += nD ;

#if MYDEBUG > 0
DA2_writeForHumanEye(stairmtx, msgFile) ;
fflush(msgFile) ;
#endif
}
DChvManager_releaseListOfObjects(manager, firstchild) ;

if ( msglvl > 2 ) {
   fprintf(msgFile, "\n ### finished assemble for stairfront =%d ", J) ;
   fflush(msgFile) ;
}

return ; }

/*--------------------------------------------------------------------*/
/*  scatter.c  */
/*--------------------------------------------------------------------*/
/*
   ---------------------------------------------------------------
   purpose -- to scatter the entries of a DChv object into
      a DA2 object. this method was written in support of the
      sparse QR factorization --- the following restrictions hold.
      (1) the chevron is symmetric
      (2) the rows of the chevron are scattered into the leading
          rows of the matrix
      (3) the column indices of the chevron nest with the column
          indices of the matrix

   chvI    -- chevron to be scattered
   mtxJ    -- DA2 object to receive the entries of the chevron
   colindJ -- column indices of the matrix

   created -- 97jul29, cca
   ---------------------------------------------------------------
*/
static void
DChv_scatterToDA2 (
   DChv   *chvI,
   DA2    *mtxJ,
   int    colindJ[]
) {
double   *rowI, *rowJ ;
int      icolI, ierr, inc1, inc2, irowI, jcolI, jcolJ, 
         loc, ncolI, ncolJ, nDI ;
int      *colindI ;
/*
   ---------------
   check the input
   ---------------
*/
if ( chvI == NULL || mtxJ == NULL || colindJ == NULL ) {
   fprintf(stderr, "\n fatal error in DChv_scatterToDA2(%p,%p,%p)"
           "\n bad input\n", chvI, mtxJ, colindJ) ;
   exit(-1) ;
}
if ( chvI->symflag != 0 ) {
   fprintf(stderr, "\n fatal error in DChv_scatterToDA2(%p,%p,%p)"
           "\n chevron must be symmetric\n", chvI, mtxJ, colindJ) ;
   exit(-1) ;
}
if ( (nDI = chvI->nD) > mtxJ->n1 ) {
   fprintf(stderr, "\n fatal error in DChv_scatterToDA2(%p,%p,%p)"
           "\n chvI->nD = %d, mtxJ->n1 = %d\n", 
           chvI, mtxJ, colindJ, nDI, mtxJ->n1) ;
   exit(-1) ;
}
ncolJ = mtxJ->n2 ;
/*
   ---------------------------------------------------------
   check that the column indices are nested and 
   overwrite the chevron's column indices with local indices
   ---------------------------------------------------------
*/
DChv_columnIndices(chvI, &ncolI, &colindI) ;
for ( jcolI = jcolJ = 0 ; jcolI < ncolI && jcolJ < ncolJ ; jcolI++ ) {
   while ( jcolJ < ncolJ && colindI[jcolI] != colindJ[jcolJ] ) {
      jcolJ++ ;
   }
   colindI[jcolI] = jcolJ ;
}
if ( jcolI != ncolI ) {
   for ( icolI = 0 ; icolI < jcolI ; icolI++ ) {
      colindI[icolI] = colindJ[colindI[icolI]] ;
   }
   fprintf(stderr, "\n fatal error in DChv_scatterToDA2(%p,%p,%p)"
           "\n bad indices\n", chvI, mtxJ, colindJ) ;
   fprintf(stderr, "\n colindI") ;
   IVfp80(stderr, ncolI, colindI, 80, &ierr) ;
   fprintf(stderr, "\n colindJ") ;
   IVfp80(stderr, ncolJ, colindJ, 80, &ierr) ;
   exit(-1) ;
}
/*
   ------------------------------------------------------
   scatter the entries of the chevron into the DA2 object
   ------------------------------------------------------
*/
rowI = DChv_entries(chvI) ;
inc1 = mtxJ->inc1 ;
inc2 = mtxJ->inc2 ;
rowJ = mtxJ->entries ;
if ( inc2 == 1 ) {
/*
   -------------------
   matrix is row major
   -------------------
*/
   for ( irowI = 0 ; irowI < nDI ; irowI++ ) {
      for ( jcolI = irowI ; jcolI < ncolI ; jcolI++ ) {
         rowJ[colindI[jcolI]] = rowI[jcolI] ;
      }
      rowI += ncolI - irowI - 1 ;
      rowJ += inc1 ;
   }
} else {
/*
   -----------------------
   matrix is not row major
   -----------------------
*/
   for ( irowI = 0 ; irowI < nDI ; irowI++ ) {
      for ( jcolI = irowI ; jcolI < ncolI ; jcolI++ ) {
         loc = colindI[jcolI] * inc2 ;
         rowJ[loc] = rowI[jcolI] ;
      }
      rowI += ncolI - irowI - 1 ;
      rowJ += inc1 ;
   }
}
/*
   -----------------------------
   restore the chevron's indices
   -----------------------------
*/
for ( jcolI = 0 ; jcolI < ncolI ; jcolI++ ) {
   colindI[jcolI] = colindJ[colindI[jcolI]] ;
}
return ; }

/*--------------------------------------------------------------------*/
