/*  DSolveData.c  */

#include "../DFrontMtx.h"

/*--------------------------------------------------------------------*/
/*
   -----------------------
   simplest constructor

   created -- 97jun27, cca
   -----------------------
*/
DSolveData *
DSolveData_new ( 
   void 
) {
DSolveData   *data ;

ALLOCATE(data, struct _DSolveData, 1) ;
DSolveData_setDefaultFields(data) ;

return(data) ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------
   set the default fields

   created -- 97jun27, cca
   -----------------------
*/
void
DSolveData_setDefaultFields (
   DSolveData   *data
) {
if ( data == NULL ) {
   fprintf(stderr, "\n fatal error in DSolveData_setDefaultFields(%p)"
           "\n bad input", data) ;
   exit(-1) ;
}
data->frontmtx   = NULL ;
data->manager    = NULL ;
data->matrixList = NULL ;
data->solDA2     = NULL ;
data->rhsDA2     = NULL ;
data->ownersIV   = NULL ;
data->p_mtxBJ    = NULL ;
data->p_mtxJ     = NULL ;
data->ndescLeft  = NULL ;
data->myid       =   0  ;
data->msglvl     =   0  ;
data->msgFile    = NULL ;
IVzero(3, data->stats) ;
DVzero(10, data->cpus) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   --------------------------------------------------
   clear the data fields, releasing allocated storage

   created -- 97jun27, cca
   --------------------------------------------------
*/
void
DSolveData_clearData ( 
   DSolveData   *data 
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( data == NULL ) {
   fprintf(stderr, "\n fatal error in DSolveData_clearData(%p)"
           "\n bad input\n", data) ;
   exit(-1) ;
}
/*
   ----------------------
   set the default fields
   ----------------------
*/
DSolveData_setDefaultFields(data) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   ------------------------------------------
   destructor, free's the object and its data

   created -- 97jun27, cca
   ------------------------------------------
*/
void
DSolveData_free ( 
   DSolveData   *data 
) {
if ( data == NULL ) {
   fprintf(stderr, "\n fatal error in DSolveData_free(%p)"
           "\n bad input\n", data) ;
   exit(-1) ;
}
DSolveData_clearData(data) ;
FREE(data) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------
   basic initializer

   created -- 97jun27, cca
   -----------------------
*/
void
DSolveData_init (
   DSolveData         *data,
   DFrontMtx          *frontmtx,
   DA2                *solDA2,
   DA2                *rhsDA2,
   IV                 *ownersIV,
   DDenseMtxManager   *manager,
   DDenseMtxList      *matrixList,
   DDenseMtx          **p_mtxJ,
   DDenseMtx          **p_mtxBJ,
   int                *ndescLeft
) {
data->frontmtx   = frontmtx   ;
data->manager    = manager    ;
data->matrixList = matrixList ;
data->solDA2     = solDA2     ;
data->rhsDA2     = rhsDA2     ;
data->ownersIV   = ownersIV   ;
data->p_mtxBJ    = p_mtxBJ    ;
data->p_mtxJ     = p_mtxJ     ;
data->ndescLeft  = ndescLeft  ;
IVzero(3, data->stats) ;
DVzero(10, data->cpus) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------------------------------------
   set the thread id, the message level and message file

   created -- 97jun27
   -----------------------------------------------------
*/
void
DSolveData_setInfo (
   DSolveData   *data,
   int           myid,
   int           msglvl,
   FILE          *msgFile
) {
data->myid    = myid    ;
data->msglvl  = msglvl  ;
data->msgFile = msgFile ;

return ; }

/*--------------------------------------------------------------------*/
