/*  DQRFactorData.c  */

#include "../DFrontMtx.h"

/*--------------------------------------------------------------------*/
/*
   -----------------------
   simplest constructor

   created -- 97aug25, dkw
   -----------------------
*/
DQRFactorData *
DQRFactorData_new ( 
   void 
) {
DQRFactorData   *data ;

ALLOCATE(data, struct _DQRFactorData, 1) ;
DQRFactorData_setDefaultFields(data) ;

return(data) ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------
   set the default fields

   created -- 97aug25, dkw
   -----------------------
*/
void
DQRFactorData_setDefaultFields (
   DQRFactorData   *data
) {
if ( data == NULL ) {
   fprintf(stderr, "\n fatal error in DQRFactorData_setDefaultFields(%p)"
           "\n bad input", data) ;
   exit(-1) ;
}
/*
   -------------------------
   global data, not modified
   -------------------------
*/
data->inpmtxA      = NULL ;
data->parent       = NULL ;
data->rowsIVL      = NULL ;
data->ownersIV     = NULL ;
/*
   ---------------------
   shared data, modified
   ---------------------
*/
data->frontmtx      = NULL ;
data->manager       = NULL ;
data->updatelist    = NULL ;
data->facops        = NULL ;
/*
   ----------
   local data
   ----------
*/
data->myid          =   0  ;
data->msglvl        =   0  ;
data->msgFile       = NULL ;
DVzero(10, data->cpus) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   --------------------------------------------------
   clear the data fields, releasing allocated storage

   created -- 97aug25, dkw
   --------------------------------------------------
*/
void
DQRFactorData_clearData ( 
   DQRFactorData   *data 
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( data == NULL ) {
   fprintf(stderr, "\n fatal error in DQRFactorData_clearData(%p)"
           "\n bad input\n", data) ;
   exit(-1) ;
}
/*
   ----------------------
   set the default fields
   ----------------------
*/
DQRFactorData_setDefaultFields(data) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   ------------------------------------------
   destructor, free's the object and its data

   created -- 97aug25, dkw
   ------------------------------------------
*/
void
DQRFactorData_free ( 
   DQRFactorData   *data 
) {
if ( data == NULL ) {
   fprintf(stderr, "\n fatal error in DQRFactorData_free(%p)"
           "\n bad input\n", data) ;
   exit(-1) ;
}
DQRFactorData_clearData(data) ;
FREE(data) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------
   basic initializer

   created -- 97aug25, dkw
   -----------------------
*/
void
DQRFactorData_init (
   DQRFactorData *data,
   DFrontMtx     *frontmtx,
   DInpMtx       *inpmtxA,
   IVL           *rowsIVL,
   IV            *ownersIV,
   DChvManager   *manager,
   DChvList      *updatelist,
   double        *facops
) {
data->frontmtx      = frontmtx ;
data->inpmtxA       = inpmtxA ;
data->parent        = ETree_par(frontmtx->frontETree) ;
data->rowsIVL       = rowsIVL ;
data->ownersIV      = ownersIV ;
data->manager       = manager ;
data->updatelist    = updatelist ;
data->facops        = facops    ;
DVzero(10, data->cpus) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------------------------------------
   set the thread id, the message level and message file

   created -- 97aug25, dkw
   -----------------------------------------------------
*/
void
DQRFactorData_setInfo (
   DQRFactorData *data,
   int           myid,
   int           msglvl,
   FILE          *msgFile
) {
data->myid    = myid    ;
data->msglvl  = msglvl  ;
data->msgFile = msgFile ;

return ; }

/*--------------------------------------------------------------------*/
