/*  DFactorData.c  */

#include "../DFrontMtx.h"

/*--------------------------------------------------------------------*/
/*
   -----------------------
   simplest constructor

   created -- 97may30, cca
   -----------------------
*/
DFactorData *
DFactorData_new ( 
   void 
) {
DFactorData   *data ;

ALLOCATE(data, struct _DFactorData, 1) ;
DFactorData_setDefaultFields(data) ;

return(data) ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------
   set the default fields

   created -- 97may30, cca
   -----------------------
*/
void
DFactorData_setDefaultFields (
   DFactorData   *data
) {
if ( data == NULL ) {
   fprintf(stderr, "\n fatal error in DFactorData_setDefaultFields(%p)"
           "\n bad input", data) ;
   exit(-1) ;
}
/*
   -------------------------
   global data, not modified
   -------------------------
*/
data->pencil       = NULL ;
data->tau          =  0.0 ;
data->droptol      =  0.0 ;
data->parent       = NULL ;
data->ownersIV     = NULL ;
data->lookahead    =   0  ;
/*
   ---------------------
   shared data, modified
   ---------------------
*/
data->frontmtx      = NULL ;
data->manager       = NULL ;
data->aggregatelist = NULL ;
data->postponedlist = NULL ;
/*
   ----------
   local data
   ----------
*/
data->myid          =   0  ;
data->fronts        = NULL ;
data->msglvl        =   0  ;
data->msgFile       = NULL ;
IVzero(10, data->stats) ;
DVzero(20, data->cpus) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   --------------------------------------------------
   clear the data fields, releasing allocated storage

   created -- 97may30, cca
   --------------------------------------------------
*/
void
DFactorData_clearData ( 
   DFactorData   *data 
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( data == NULL ) {
   fprintf(stderr, "\n fatal error in DFactorData_clearData(%p)"
           "\n bad input\n", data) ;
   exit(-1) ;
}
/*
   ----------------------
   free the owned storage
   ----------------------
*/
if ( data->fronts != NULL ) {
   FREE(data->fronts) ;
}
/*
   ----------------------
   set the default fields
   ----------------------
*/
DFactorData_setDefaultFields(data) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   ------------------------------------------
   destructor, free's the object and its data

   created -- 97may30, cca
   ------------------------------------------
*/
void
DFactorData_free ( 
   DFactorData   *data 
) {
if ( data == NULL ) {
   fprintf(stderr, "\n fatal error in DFactorData_free(%p)"
           "\n bad input\n", data) ;
   exit(-1) ;
}
DFactorData_clearData(data) ;
FREE(data) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------
   basic initializer

   created -- 97may30, cca
   -----------------------
*/
void
DFactorData_init (
   DFactorData   *data,
   DFrontMtx     *frontmtx,
   DPencil       *pencil,
   double        tau,
   double        droptol,
   IV            *ownersIV,
   int           lookahead,
   DChvManager   *manager,
   DChvList      *aggregatelist,
   DChvList      *postponedlist
) {
int   J ;

data->frontmtx      = frontmtx ;
data->pencil        = pencil  ;
data->tau           = tau ;
data->droptol       = droptol ;
data->parent        = ETree_par(frontmtx->frontETree) ;
data->ownersIV      = ownersIV ;
data->lookahead     = lookahead ;
data->manager       = manager ;
data->aggregatelist = aggregatelist ;
data->postponedlist = postponedlist ;
ALLOCATE(data->fronts, struct _DChv *, frontmtx->nfront) ;
for ( J = 0 ; J < frontmtx->nfront ; J++ ) {
   data->fronts[J] = NULL ;
}
IVzero(10, data->stats) ;
DVzero(20, data->cpus) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------------------------------------
   set the thread id, the message level and message file

   created -- 97may30
   -----------------------------------------------------
*/
void
DFactorData_setInfo (
   DFactorData   *data,
   int           myid,
   int           msglvl,
   FILE          *msgFile
) {
data->myid    = myid    ;
data->msglvl  = msglvl  ;
data->msgFile = msgFile ;

return ; }

/*--------------------------------------------------------------------*/
