/*  testIO.c  */

#include "../DFrontMtx.h"
#include "../../timings.h"

/*--------------------------------------------------------------------*/

void
main ( int argc, char *argv[] )
/*
   ------------------------------------------------------
   test DFrontMtx_readFromFile and DFrontMtx_writeToFile,
   useful for translating between formatted *.frontmtxf
   and binary *.frontmtxb files.

   created -- 97jun18, cca
   ------------------------------------------------------
*/
{
char        *inDFrontMtxFileName, *outDFrontMtxFileName ;
double      t1, t2 ;
int         msglvl, rc ;
DFrontMtx   *frontmtx ;
FILE        *msgFile ;

if ( argc != 5 ) {
   fprintf(stdout, 
     "\n\n usage : %s msglvl msgFile inFile outFile"
     "\n    msglvl   -- message level"
     "\n    msgFile  -- message file"
     "\n    inFile   -- input file, must be *.frontmtxf or *.frontmtxb"
     "\n    outFile  -- output file, must be *.frontmtxf or *.frontmtxb"
     "\n", argv[0]) ;
   return ;
}
msglvl = atoi(argv[1]) ;
if ( strcmp(argv[2], "stdout") == 0 ) {
   msgFile = stdout ;
} else if ( (msgFile = fopen(argv[2], "a")) == NULL ) {
   fprintf(stderr, "\n fatal error in %s"
           "\n unable to open file %s\n",
           argv[0], argv[2]) ;
   return ;
}
inDFrontMtxFileName  = argv[3] ;
outDFrontMtxFileName = argv[4] ;
fprintf(msgFile, 
        "\n %s "
        "\n msglvl   -- %d" 
        "\n msgFile  -- %s" 
        "\n inFile   -- %s" 
        "\n outFile  -- %s" 
        "\n",
        argv[0], msglvl, argv[2], 
        inDFrontMtxFileName, outDFrontMtxFileName) ;
fflush(msgFile) ;
/*
   ----------------------------
   read in the DFrontMtx object
   ----------------------------
*/
if ( strcmp(inDFrontMtxFileName, "none") == 0 ) {
   fprintf(msgFile, "\n no file to read from") ;
   exit(0) ;
}
frontmtx = DFrontMtx_new() ;
MARKTIME(t1) ;
rc = DFrontMtx_readFromFile(frontmtx, inDFrontMtxFileName) ;
MARKTIME(t2) ;
fprintf(msgFile, "\n CPU %9.5f : read in frontmtx from file %s",
        t2 - t1, inDFrontMtxFileName) ;
if ( rc != 1 ) {
   fprintf(msgFile, 
           "\n return value %d from DFrontMtx_readFromFile(%p,%s)",
           rc, frontmtx, inDFrontMtxFileName) ;
   exit(-1) ;
}
fprintf(msgFile, "\n\n after reading DFrontMtx object from file %s",
        inDFrontMtxFileName) ;
if ( msglvl > 2 ) {
   DFrontMtx_writeForHumanEye(frontmtx, msgFile) ;
} else {
   DFrontMtx_writeStats(frontmtx, msgFile) ;
}
fflush(msgFile) ;
/*
   ----------------------------
   write out the DFrontMtx object
   ----------------------------
*/
if ( strcmp(outDFrontMtxFileName, "none") != 0 ) {
   MARKTIME(t1) ;
   rc = DFrontMtx_writeToFile(frontmtx, outDFrontMtxFileName) ;
   MARKTIME(t2) ;
   fprintf(msgFile, "\n CPU %9.5f : write frontmtx to file %s",
           t2 - t1, outDFrontMtxFileName) ;
}
if ( rc != 1 ) {
   fprintf(msgFile, 
           "\n return value %d from DFrontMtx_writeToFile(%p,%s)",
           rc, frontmtx, outDFrontMtxFileName) ;
}
/*
   -------------------------
   free the DFrontMtx object
   -------------------------
*/
DFrontMtx_free(frontmtx) ;

fprintf(msgFile, "\n") ;
fclose(msgFile) ;

return ; }

/*--------------------------------------------------------------------*/
