/*  util.c  */

#include "../DDenseMtxManager.h"

#define MYDEBUG 0

/*--------------------------------------------------------------------*/
/*
   -----------------------------------------------
   return a pointer to a DDenseMtx object that has 
   been initialized with the input parameters

   created -- 97may24, cca
   -----------------------------------------------
*/
DDenseMtx *
DDenseMtxManager_newObjectOfSizeNbytes (
   DDenseMtxManager   *manager,
   int                nbytesNeeded
) {
DDenseMtx   *mtx, *prev ;
int         nbytesAvailable, newinstance ;
/*
   ---------------
   check the input
   ---------------
*/
if ( manager == NULL || nbytesNeeded <= 0 ) {
   fprintf(stderr, 
      "\n fatal error in DDenseMtxMananger_newObjectOfSizeNbytes(%p,%d)"
      "\n bad input\n", manager, nbytesNeeded) ;
   exit(-1) ;
}
if ( manager->lock != NULL ) {
/*
   -----------------------------------------------
   lock the lock, get exclusive access to the list
   -----------------------------------------------
*/
#if MYDEBUG > 1
   fprintf(stdout, "\n manager: locking") ;
   fflush(stdout) ;
#endif
   Lock_lock(manager->lock) ;
   manager->nlocks++ ;
#if MYDEBUG > 1
   fprintf(stdout, "\n manager : locking in newObject, %d locks",
           manager->nlocks) ;
   fflush(stdout) ;
#endif
#if MYDEBUG > 1
   fprintf(stdout, ", %d locks so far", manager->nlocks) ;
   fflush(stdout) ;
#endif
}
/*
   ---------------------------------------------------------
   find a DDenseMtx object with the required number of bytes
   ---------------------------------------------------------
*/
for ( mtx = manager->head, prev = NULL ; 
      mtx != NULL ; 
      mtx = mtx->next ) {
   nbytesAvailable = DDenseMtx_nbytesInWorkspace(mtx) ;
#if MYDEBUG > 1
   fprintf(stdout, "\n free chev %p, nbytes = %d",
           mtx, nbytesAvailable) ;
   fflush(stdout) ;
#endif
   if ( nbytesNeeded <= nbytesAvailable ) {
      break ;
   }
   prev = mtx ;
}
if ( mtx != NULL ) {
/*
   ---------------------------------------
   suitable object found, remove from list
   ---------------------------------------
*/
#if MYDEBUG > 1
   fprintf(stdout, "\n postponed mtx = %p, %d nbytes available",
           mtx, nbytesAvailable) ;
   fflush(stdout) ;
#endif
   if ( prev == NULL ) {
      manager->head = mtx->next ;
   } else {
      prev->next = mtx->next ;
   }
   newinstance = 0 ;
} else {
/*
   ------------------------------------------------------------------
   no suitable object found, create new instance and allocate storage
   ------------------------------------------------------------------
*/
   mtx = DDenseMtx_new() ;
   manager->nactive++ ;
#if MYDEBUG > 1
   fprintf(stdout, "\n new postponed mtx = %p", mtx) ;
   fflush(stdout) ;
#endif
   newinstance = 1 ;
   DV_setSize(&mtx->wrkDV, nbytesNeeded/sizeof(double)) ;
}
if ( newinstance == 1 ) {
   manager->nbytesactive += DDenseMtx_nbytesInWorkspace(mtx) ;
}
manager->nbytesrequested += nbytesNeeded ;
#if MYDEBUG > 1
fprintf(stdout, "\n %d bytes active, %d bytes requested",
        manager->nbytesactive, manager->nbytesrequested) ;
#endif
manager->nrequests++ ;
if ( manager->lock != NULL ) {
/*
   -----------------------------------------------------
   unlock the lock, release exclusive access to the list
   -----------------------------------------------------
*/
   manager->nunlocks++ ;
#if MYDEBUG > 1
   fprintf(stdout, "\n manager: unlocking, %d unlocks so far",
           manager->nunlocks) ;
   fflush(stdout) ;
#endif
   Lock_unlock(manager->lock) ;
}
return(mtx) ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------------
   release a DDenseMtx instance

   created -- 97may24, cca
   ----------------------------
*/
void
DDenseMtxManager_releaseObject (
   DDenseMtxManager   *manager,
   DDenseMtx          *mtx1
) {
DDenseMtx   *mtx2, *prev ;
int         nbytes1, nbytes2 ;
/*
   ---------------
   check the input
   ---------------
*/
if ( manager == NULL || mtx1 == NULL ) {
   fprintf(stderr, 
       "\n fatal error in DDenseMtxManager_releaseObject(%p,%p)"
       "\n bad input\n", manager, mtx1) ;
   exit(-1) ;
}
if ( manager->lock != NULL ) {
/*
   -----------------------------------------------
   lock the lock, get exclusive access to the list
   -----------------------------------------------
*/
   Lock_lock(manager->lock) ;
   manager->nlocks++ ;
#if MYDEBUG > 1
   fprintf(stdout, "\n manager : locking in releaseObject, %d locks",
           manager->nlocks) ;
   fflush(stdout) ;
#endif
}
/*
   --------------------------------------------------------
   find a place in the list where the DDenseMtx objects are 
   sorted in ascending order of the size of their workspace
   --------------------------------------------------------
*/
nbytes1 = DDenseMtx_nbytesInWorkspace(mtx1) ;
#if MYDEBUG > 1
fprintf(stdout, "\n\n trying to release chevron %p with %d bytes",
        mtx1, nbytes1) ;
#endif
for ( mtx2 = manager->head, prev = NULL ; 
      mtx2 != NULL ; 
      mtx2 = mtx2->next ) {
   nbytes2 = DDenseMtx_nbytesInWorkspace(mtx2) ;
#if MYDEBUG > 1
   fprintf(stdout, "\n list chevron %p with %d bytes", mtx2, nbytes2) ;
#endif
   if ( nbytes2 > nbytes1 ) {
      break ;
   }
   prev = mtx2 ;
}
if ( prev == NULL ) {
   manager->head = mtx1 ;
#if MYDEBUG > 1
   fprintf(stdout, "\n manager->head = %p", mtx1) ;
#endif
} else {
   prev->next = mtx1 ;
#if MYDEBUG > 1
   fprintf(stdout, "\n %p->next = %p", prev, mtx1) ;
#endif
}
mtx1->next = mtx2 ;
#if MYDEBUG > 1
fprintf(stdout, "\n %p->next = %p", mtx1, mtx2) ;
#endif
manager->nreleases++ ;
if ( manager->lock != NULL ) {
/*
   -----------------------------------------------------
   unlock the lock, release exclusive access to the list
   -----------------------------------------------------
*/
   manager->nunlocks++ ;
   Lock_unlock(manager->lock) ;
}
return ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------------------
   release a list of DDenseMtx objects

   created -- 97may29, cca
   -----------------------------------
*/
void
DDenseMtxManager_releaseListOfObjects (
   DDenseMtxManager   *manager,
   DDenseMtx          *head
) {
DDenseMtx   *mtx1, *mtx2, *prev ;
int         nbytes1, nbytes2 ;
/*
   ---------------
   check the input
   ---------------
*/
if ( manager == NULL || head == NULL ) {
   fprintf(stderr, 
       "\n fatal error in DDenseMtxManager_releaseListOfObjects(%p,%p)"
       "\n bad input\n", manager, head) ;
   exit(-1) ;
}
if ( manager->lock != NULL ) {
/*
   -----------------------------------------------
   lock the lock, get exclusive access to the list
   -----------------------------------------------
*/
   Lock_lock(manager->lock) ;
   manager->nlocks++ ;
#if MYDEBUG > 1
   fprintf(stdout, 
           "\n manager : locking in releaseListOfObjects, %d locks",
           manager->nlocks) ;
   fflush(stdout) ;
#endif
}
while ( head != NULL ) {
   mtx1 = head ;
   head = mtx1->next ;
/*
   --------------------------------------------------------
   find a place in the list where the DDenseMtx objects are 
   sorted in ascending order of the size of their workspace
   --------------------------------------------------------
*/
   nbytes1 = DDenseMtx_nbytesInWorkspace(mtx1) ;
#if MYDEBUG > 1
   fprintf(stdout, "\n\n trying to release chevron %p with %d bytes",
           mtx1, nbytes1) ;
#endif
   for ( mtx2 = manager->head, prev = NULL ; 
         mtx2 != NULL ; 
         mtx2 = mtx2->next ) {
      nbytes2 = DDenseMtx_nbytesInWorkspace(mtx2) ;
#if MYDEBUG > 1
      fprintf(stdout, 
              "\n list chevron %p with %d bytes", mtx2, nbytes2) ;
#endif
      if ( nbytes2 > nbytes1 ) {
         break ;
      }
      prev = mtx2 ;
   }
   if ( prev == NULL ) {
      manager->head = mtx1 ;
#if MYDEBUG > 1
      fprintf(stdout, "\n manager->head = %p", mtx1) ;
#endif
   } else {
      prev->next = mtx1 ;
#if MYDEBUG > 1
      fprintf(stdout, "\n %p->next = %p", prev, mtx1) ;
#endif
   }
   mtx1->next = mtx2 ;
#if MYDEBUG > 1
   fprintf(stdout, "\n %p->next = %p", mtx1, mtx2) ;
#endif
   manager->nreleases++ ;
}
if ( manager->lock != NULL ) {
/*
   -----------------------------------------------------
   unlock the lock, release exclusive access to the list
   -----------------------------------------------------
*/
   manager->nunlocks++ ;
   Lock_unlock(manager->lock) ;
}
return ; }

/*--------------------------------------------------------------------*/
