/*  init.c  */

#include "../DDenseMtxManager.h"

/*--------------------------------------------------------------------*/
/*
   ---------------------------------------------------------------
   simple initializer

   lockflag = 0 --> mutex lock is not allocated or initialized
   lockflag = 1 --> mutex lock is allocated and it can synchronize
                    omly threads in this process.
   lockflag = 2 --> mutex lock is allocated and it can synchronize
                    omly threads in this and other processes.
                        
   created -- 97jun08, cca
   ---------------------------------------------------------------
*/
void
DDenseMtxManager_init (
   DDenseMtxManager   *manager,
   int                lockflag
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( manager == NULL || lockflag < 0 || lockflag > 2 ) {
   fprintf(stderr, "\n fatal error in DDenseMtxManager_init(%p,%d)"
           "\n bad input\n", manager, lockflag) ;
   exit(-1) ;
}
/*
   --------------------------------------------------
   clear any previous data and set the default fields
   --------------------------------------------------
*/
DDenseMtxManager_clearData(manager) ;
if ( lockflag != 0 ) {
/*
   ---------------------------
   initialize the mutex object
   ---------------------------
*/
   manager->lock = Lock_new() ;
   Lock_init(manager->lock, lockflag) ;
}
return ; }

/*--------------------------------------------------------------------*/
