/*  basics.c  */

#include "../DDenseMtxManager.h"

#define   MYDEBUG 0

/*--------------------------------------------------------------------*/
/*
   -----------------------
   simplest constructor

   created -- 97jun08, cca
   -----------------------
*/
DDenseMtxManager *
DDenseMtxManager_new ( 
   void 
) {
DDenseMtxManager   *manager ;

ALLOCATE(manager, struct _DDenseMtxManager, 1) ;
DDenseMtxManager_setDefaultFields(manager) ;

return(manager) ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------
   set the default fields

   created -- 97jun08, cca
   -----------------------
*/
void
DDenseMtxManager_setDefaultFields (
   DDenseMtxManager   *manager
) {
if ( manager == NULL ) {
   fprintf(stderr, 
           "\n fatal error in DDenseMtxManager_setDefaultFields(%p)"
           "\n bad input", manager) ;
   exit(-1) ;
}
manager->head            = NULL ;
manager->lock            = NULL ;
manager->nactive         =   0  ;
manager->nbytesactive    =   0  ;
manager->nbytesrequested =   0  ;
manager->nrequests       =   0  ;
manager->nreleases       =   0  ;
manager->nlocks          =   0  ;
manager->nunlocks        =   0  ;

return ; }

/*--------------------------------------------------------------------*/
/*
   --------------------------------------------------
   clear the data fields, releasing allocated storage

   created -- 97jun08, cca
   --------------------------------------------------
*/
void
DDenseMtxManager_clearData ( 
   DDenseMtxManager   *manager 
) {
DDenseMtx   *mtx ;
/*
   ---------------
   check the input
   ---------------
*/
if ( manager == NULL ) {
   fprintf(stderr, "\n fatal error in DDenseMtxManager_clearData(%p)"
           "\n bad input\n", manager) ;
   exit(-1) ;
}
/*
   ------------------------
   free the working storage
   ------------------------
*/
while ( (mtx = manager->head) != NULL ) {
   manager->head = mtx->next ;
   DDenseMtx_free(mtx) ;
}
if ( manager->lock != NULL ) {
/*
   -------------------------
   destroy and free the lock
   -------------------------
*/
   Lock_free(manager->lock) ;
}
/*
   ----------------------
   set the default fields
   ----------------------
*/
DDenseMtxManager_setDefaultFields(manager) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   ------------------------------------------
   destructor, free's the object and its data

   created -- 97jun08, cca
   ------------------------------------------
*/
void
DDenseMtxManager_free ( 
   DDenseMtxManager   *manager 
) {
if ( manager == NULL ) {
   fprintf(stderr, "\n fatal error in DDenseMtxManager_free(%p)"
           "\n bad input\n", manager) ;
   exit(-1) ;
}
DDenseMtxManager_clearData(manager) ;
FREE(manager) ;

return ; }

/*--------------------------------------------------------------------*/
