/*  IO.c  */

#include "../DDenseMtxManager.h"

/*--------------------------------------------------------------------*/
/*
   ----------------------------------------
   purpose -- to write the object to a file
              in human readable form

   created -- 97jun08, cca
   ----------------------------------------
*/
void
DDenseMtxManager_writeForHumanEye (
   DDenseMtxManager   *manager,
   FILE               *fp
) {
DDenseMtx   *mtx ;
/*
   ---------------
   check the input
   ---------------
*/
if ( manager == NULL || fp == NULL ) {
   fprintf(stderr, 
           "\n fatal error in DDenseMtxManager_writeForHumanEye(%p,%p)"
           "\n bad input\n", manager, fp) ;
   exit(-1) ;
}
fprintf(fp, "\n DDenseMtxManager object at address %p"
        "\n     %d active objects"
        "\n     %d total bytes requested, %d total bytes allocated " 
        "\n     %d requests, %d releases, %d locks, %d unlocks", 
        manager,
        manager->nactive,
        manager->nbytesrequested,
        manager->nbytesactive,
        manager->nrequests,
        manager->nreleases,
        manager->nlocks,
        manager->nunlocks) ;
/*
for ( mtx = manager->head ; mtx != NULL ; mtx = mtx->next ) {
   fprintf(fp, "\n mtx (%d,%d), nbytes %d",
           mtx->rowid, mtx->colid, DDenseMtx_nbytesInWorkspace(mtx)) ;
}
*/
return ; }

/*--------------------------------------------------------------------*/
