/*  DDenseMtxManager.h  */

#include "../DDenseMtx.h"
#include "../Lock.h"
 
/*--------------------------------------------------------------------*/
/*
*/
typedef struct _DDenseMtxManager  DDenseMtxManager ;
struct _DDenseMtxManager {
   DDenseMtx   *head           ;
   Lock        *lock           ;
   int         nactive         ;
   int         nbytesactive    ;
   int         nbytesrequested ;
   int         nrequests       ;
   int         nreleases       ;
   int         nlocks          ;
   int         nunlocks        ;
} ;
/*--------------------------------------------------------------------*/
/*
------------------------------------------------------------------------
----- methods found in basics.c ----------------------------------------
------------------------------------------------------------------------
*/
/*
   -----------------------
   simplest constructor
 
   created -- 97jun08, cca
   -----------------------
*/
DDenseMtxManager *
DDenseMtxManager_new ( 
   void 
) ;
/*
   -----------------------
   set the default fields
 
   created -- 97jun08, cca
   -----------------------
*/
void
DDenseMtxManager_setDefaultFields (
   DDenseMtxManager   *manager
) ;
/*
   --------------------------------------------------
   clear the data fields, releasing allocated storage
 
   created -- 97jun08, cca
   --------------------------------------------------
*/
void
DDenseMtxManager_clearData (
   DDenseMtxManager   *manager
) ;
/*
   ------------------------------------------
   destructor, free's the object and its data
 
   created -- 97jun08, cca
   ------------------------------------------
*/
void
DDenseMtxManager_free (
   DDenseMtxManager   *manager
) ;
/*--------------------------------------------------------------------*/
/*
------------------------------------------------------------------------
----- methods found in init.c ------------------------------------------
------------------------------------------------------------------------
*/
/*
   ---------------------------------------------------------------
   simple initializer
 
   lockflag = 0 --> mutex lock is not allocated or initialized
   lockflag = 1 --> mutex lock is allocated and it can synchronize
                    only threads in this process.
   lockflag = 2 --> mutex lock is allocated and it can synchronize
                    only threads in this and other processes.
                                
   created -- 97jun08, cca
   ---------------------------------------------------------------
*/
void
DDenseMtxManager_init (
   DDenseMtxManager   *manager,
   int                lockflag
) ;
/*--------------------------------------------------------------------*/
/*
------------------------------------------------------------------------
----- methods found in util.c ------------------------------------------
------------------------------------------------------------------------
*/
/*
   -----------------------------------------------
   return a pointer to a DDenseMtx object that has 
   been initialized with the input parameters
 
   created -- 97may24, cca
   -----------------------------------------------
*/
DDenseMtx *
DDenseMtxManager_newObjectOfSizeNbytes (
   DDenseMtxManager   *manager,
   int                nbytesNeeded
) ;
/*
   ----------------------------
   release a DDenseMtx instance
 
   created -- 97jun08, cca
   ----------------------------
*/
void
DDenseMtxManager_releaseObject (
   DDenseMtxManager   *manager,
   DDenseMtx          *mtx
) ;
/*
   -----------------------------------
   release a list of DDenseMtx objects
 
   created -- 97jun08, cca
   -----------------------------------
*/
void
DDenseMtxManager_releaseListOfObjects (
   DDenseMtxManager   *manager,
   DDenseMtx          *head
) ;
/*--------------------------------------------------------------------*/
/*
------------------------------------------------------------------------
----- methods found in IO.c --------------------------------------------
------------------------------------------------------------------------
*/
/*
   ----------------------------------------
   purpose -- to write the object to a file
              in human readable form
 
   created -- 97jun08, cca
   ----------------------------------------
*/
void
DDenseMtxManager_writeForHumanEye (
   DDenseMtxManager   *manager,
   FILE               *fp
) ;
/*--------------------------------------------------------------------*/
