/*  basics.c  */

#include "../DDenseMtxList.h"

#define   MYDEBUG 0

/*--------------------------------------------------------------------*/
/*
   -----------------------
   simplest constructor

   created -- 97jun08, cca
   -----------------------
*/
DDenseMtxList *
DDenseMtxList_new ( 
   void 
) {
DDenseMtxList   *list ;

ALLOCATE(list, struct _DDenseMtxList, 1) ;
DDenseMtxList_setDefaultFields(list) ;

return(list) ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------
   set the default fields

   created -- 97jun08, cca
   -----------------------
*/
void
DDenseMtxList_setDefaultFields (
   DDenseMtxList   *list
) {
if ( list == NULL ) {
   fprintf(stderr, 
           "\n fatal error in DDenseMtxList_setDefaultFields(%p)"
           "\n bad input", list) ;
   exit(-1) ;
}
list->nlist  =   0  ;
list->heads  = NULL ;
list->counts = NULL ;
list->lock   = NULL ;
list->flags  = NULL ;
list->nlocks =   0  ;

return ; }

/*--------------------------------------------------------------------*/
/*
   --------------------------------------------------
   clear the data fields, releasing allocated storage

   created -- 97jun08, cca
   --------------------------------------------------
*/
void
DDenseMtxList_clearData ( 
   DDenseMtxList   *list 
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( list == NULL ) {
   fprintf(stderr, "\n fatal error in DDenseMtxList_clearData(%p)"
           "\n bad input\n", list) ;
   exit(-1) ;
}
/*
   -------------
   free the data
   -------------
*/
if ( list->heads != NULL ) {
   FREE(list->heads) ;
}
if ( list->counts != NULL ) {
   IVfree(list->counts) ;
}
if ( list->flags != NULL ) {
   CVfree(list->flags) ;
}
if ( list->lock != NULL ) {
/*
   -------------------------
   destroy and free the lock
   -------------------------
*/
   Lock_free(list->lock) ;
}
/*
   ----------------------
   set the default fields
   ----------------------
*/
DDenseMtxList_setDefaultFields(list) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   ------------------------------------------
   destructor, free's the object and its data

   created -- 97jun08, cca
   ------------------------------------------
*/
void
DDenseMtxList_free ( 
   DDenseMtxList   *list 
) {
if ( list == NULL ) {
   fprintf(stderr, "\n fatal error in DDenseMtxList_free(%p)"
           "\n bad input\n", list) ;
   exit(-1) ;
}
DDenseMtxList_clearData(list) ;
FREE(list) ;

return ; }

/*--------------------------------------------------------------------*/
