/*  IO.c  */

#include "../DDenseMtxList.h"

/*--------------------------------------------------------------------*/
/*
   ----------------------------------------
   purpose -- to write the object to a file
              in human readable form

   created -- 97jun08, cca
   ----------------------------------------
*/
void
DDenseMtxList_writeForHumanEye (
   DDenseMtxList   *list,
   FILE            *fp
) {
DDenseMtx   *mtx ;
int         ilist ;
/*
   ---------------
   check the input
   ---------------
*/
if ( list == NULL || fp == NULL ) {
   fprintf(stderr, 
           "\n fatal error in DDenseMtxList_writeForHumanEye(%p,%p)"
           "\n bad input\n", list, fp) ;
   exit(-1) ;
}
fprintf(fp, "\n DDenseMtxList object at address %p"
            "\n %d lists, %d locks", list, list->nlist, list->nlocks) ;
for ( ilist = 0 ; ilist < list->nlist ; ilist++ ) {
   if ( (mtx = list->heads[ilist]) != NULL ) {
      fprintf(fp, "\n list %d :", ilist) ;
      while ( mtx != NULL ) {
         fprintf(fp, "\n    mtx (%d,%d), nbytes %d",
                 mtx->rowid, mtx->colid, 
                 DDenseMtx_nbytesInWorkspace(mtx)) ;
         mtx = mtx->next ;
      }
   }
}
return ; }

/*--------------------------------------------------------------------*/
