/*  util.c  */

#include "../DDenseMtx.h"

#define MYDEBUG 0

/*--------------------------------------------------------------------*/
/*
   ---------------------------------------------------------
   sort the rows so the row ids are in ascending order
   sort the columns so the column ids are in ascending order

   created -- 97jul13, cca
   ---------------------------------------------------------
*/
void
DDenseMtx_sort (
   DDenseMtx   *mtx
) {
DA2   da2 ;
int   ii, ncol, nrow, sortColumns, sortRows ;
int   *colind, *rowind ;
/*
   ----------------
   check the output
   ----------------
*/
if ( mtx == NULL ) {
   fprintf(stderr, "\n fatal error in DDenseMtx_sort(%p)"
           "\n bad input\n", mtx) ;
   exit(-1) ;
}
sortRows = sortColumns = 0 ;
DDenseMtx_rowIndices(mtx, &nrow, &rowind) ;
for ( ii = 1 ; ii < nrow ; ii++ ) {
   if ( rowind[ii-1] > rowind[ii] ) {
      sortRows = 1 ;
      break ;
   }
}
DDenseMtx_columnIndices(mtx, &ncol, &colind) ;
for ( ii = 1 ; ii < ncol ; ii++ ) {
   if ( colind[ii-1] > colind[ii] ) {
      sortColumns = 1 ;
      break ;
   }
}
if ( sortRows == 0 && sortColumns == 0 ) {
   return ;
}
DA2_setDefaultFields(&da2) ;
DDenseMtx_setDA2(mtx, &da2) ;
if ( sortRows == 1 ) {
   DA2_sortRowsUp(&da2, nrow, rowind) ;
}
if ( sortColumns == 1 ) {
   DA2_sortColumnsUp(&da2, ncol, colind) ;
}
return ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------------------------------
   copy row irowA from mtxA into row irowB in mtxB

   created -- 97jul13, cca
   -----------------------------------------------
*/
void
DDenseMtx_copyRow (
   DDenseMtx   *mtxB,
   int         irowB,
   DDenseMtx   *mtxA,
   int         irowA
) {
double   *rowA, *rowB ;
int      ii, inc2A, inc2B, iA, iB, ncol ;
/*
   ---------------
   check the input
   ---------------
*/
if (  mtxB == NULL || irowB < 0 || irowB >= mtxB->nrow 
   || mtxA == NULL || irowA < 0 || irowA >= mtxA->nrow 
   || (ncol = mtxA->ncol) != mtxB->ncol ) {
   fprintf(stderr, "\n fatal error in DDenseMtx_copyRow(%p,%d,%p,%d)"
           "\n bad input\n", mtxB, irowB, mtxA, irowA) ;
   exit(-1) ;
}
inc2A = mtxA->inc2 ;
rowA  = mtxA->entries + irowA*mtxA->inc1 ;
inc2B = mtxB->inc2 ;
rowB  = mtxB->entries + irowB*mtxB->inc1 ;
mtxB->rowind[irowB] = mtxA->rowind[irowA] ; 
for ( ii = iA = iB = 0 ; ii < ncol ; ii++, iA += inc2A, iB += inc2B ) {
   rowB[iB] = rowA[iA] ;
}
return ; }

/*--------------------------------------------------------------------*/
