/*  instance.c  */

#include "../DDenseMtx.h"

/*--------------------------------------------------------------------*/
/*
   -------------------------------
   return the row id of the object

   created -- 97jun08, cca
   -------------------------------
*/
int
DDenseMtx_rowid (
   DDenseMtx   *mtx
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( mtx == NULL ) {
   fprintf(stderr, "\n fatal error in DDenseMtx_rowid(%p)"
           "\n bad input\n", mtx) ;
   exit(-1) ;
}
return(mtx->rowid) ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------------------
   return the column id of the object

   created -- 97jun08, cca
   ----------------------------------
*/
int
DDenseMtx_colid (
   DDenseMtx   *mtx
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( mtx == NULL ) {
   fprintf(stderr, "\n fatal error in DDenseMtx_colid(%p)"
           "\n bad input\n", mtx) ;
   exit(-1) ;
}
return(mtx->colid) ; }

/*--------------------------------------------------------------------*/
/*
   ------------------------------------------
   fill *pnrow with nrow and *pncol with ncol

   created -- 97jun08, cca
   ------------------------------------------
*/
void
DDenseMtx_dimensions (
   DDenseMtx   *mtx,
   int         *pnrow,
   int         *pncol
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( mtx == NULL || pnrow == NULL || pncol == NULL ) {
   fprintf(stderr, "\n fatal error in DDenseMtx_dimensions(%p,%p,%p)"
           "\n bad input\n", mtx, pnrow, pncol) ;
   exit(-1) ;
}
*pnrow = mtx->nrow ;
*pncol = mtx->ncol ;

return ; }

/*--------------------------------------------------------------------*/
/*
   ------------------------
   return the row increment

   created -- 97jun18, cca
   ------------------------
*/
int
DDenseMtx_rowIncrement (
   DDenseMtx   *mtx
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( mtx == NULL ) {
   fprintf(stderr, "\n fatal error in DDenseMtx_rowIncrement(%p)"
           "\n bad input\n", mtx) ;
   exit(-1) ;
}
return(mtx->inc1) ; }

/*--------------------------------------------------------------------*/
/*
   ---------------------------
   return the column increment

   created -- 97jun18, cca
   ---------------------------
*/
int
DDenseMtx_columnIncrement (
   DDenseMtx   *mtx
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( mtx == NULL ) {
   fprintf(stderr, "\n fatal error in DDenseMtx_columnIncrement(%p)"
           "\n bad input\n", mtx) ;
   exit(-1) ;
}
return(mtx->inc2) ; }

/*--------------------------------------------------------------------*/
/*
   -------------------------------------------
   fill *pnrow with nrow, *prowind with rowind

   created -- 97jun08, cca
   -------------------------------------------
*/
void
DDenseMtx_rowIndices (
   DDenseMtx   *mtx,
   int         *pnrow,
   int         **prowind
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( mtx == NULL || pnrow == NULL || prowind == NULL ) {
   fprintf(stderr, "\n fatal error in DDenseMtx_rowIndices(%p,%p,%p)"
           "\n bad input\n", mtx, pnrow, prowind) ;
   exit(-1) ;
}
*pnrow   = mtx->nrow   ;
*prowind = mtx->rowind ;

return ; }

/*--------------------------------------------------------------------*/
/*
   -------------------------------------------
   fill *pncol with ncol, *pcolind with colind

   created -- 97jun08, cca
   -------------------------------------------
*/
void
DDenseMtx_columnIndices (
   DDenseMtx   *mtx,
   int         *pncol,
   int         **pcolind
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( mtx == NULL || pncol == NULL || pcolind == NULL ) {
   fprintf(stderr, "\n fatal error in DDenseMtx_columnIndices(%p,%p,%p)"
           "\n bad input\n", mtx, pncol, pcolind) ;
   exit(-1) ;
}
*pncol   = mtx->ncol   ;
*pcolind = mtx->colind ;

return ; }

/*--------------------------------------------------------------------*/
/*
   -------------------------------
   return a pointer to the entries

   created -- 97jun08, cca
   -------------------------------
*/
double *
DDenseMtx_entries(
   DDenseMtx   *mtx
) {
/*
   ---------------
   check the input
   ---------------
*/
if (  mtx == NULL ) {
   fprintf(stderr, "\n fatal error in DDenseMtx_entries(%p)"
           "\n bad input\n", mtx) ;
   exit(-1) ;
}
return(mtx->entries) ; }

/*--------------------------------------------------------------------*/
/*
   ---------------------------------
   return a pointer to the workspace

   created -- 97nov15, cca
   ---------------------------------
*/
void *
DDenseMtx_workspace(
   DDenseMtx   *mtx
) {
/*
   ---------------
   check the input
   ---------------
*/
if (  mtx == NULL ) {
   fprintf(stderr, "\n fatal error in DDenseMtx_workspace(%p)"
           "\n bad input\n", mtx) ;
   exit(-1) ;
}
return(DV_entries(&mtx->wrkDV)) ; }

/*--------------------------------------------------------------------*/
