/*  basics.c  */

#include "../DDenseMtx.h"

#define   MYDEBUG 0

/*--------------------------------------------------------------------*/
/*
   -----------------------
   simplest constructor

   created -- 97jun08, cca
   -----------------------
*/
DDenseMtx *
DDenseMtx_new ( 
   void 
) {
DDenseMtx   *mtx ;

ALLOCATE(mtx, struct _DDenseMtx, 1) ;
DDenseMtx_setDefaultFields(mtx) ;

return(mtx) ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------
   set the default fields

   created -- 97jun08, cca
   -----------------------
*/
void
DDenseMtx_setDefaultFields (
   DDenseMtx   *mtx
) {
if ( mtx == NULL ) {
   fprintf(stderr, "\n fatal error in DDenseMtx_setDefaultFields(%p)"
           "\n bad input", mtx) ;
   exit(-1) ;
}
mtx->rowid   =  -1  ;
mtx->colid   =  -1  ;
mtx->nrow    =   0  ;
mtx->ncol    =   0  ;
mtx->inc1    =   0  ;
mtx->inc2    =   0  ;
mtx->rowind  = NULL ;
mtx->colind  = NULL ;
mtx->entries = NULL ;
DV_setDefaultFields(&mtx->wrkDV) ;
mtx->next    = NULL ;

return ; }

/*--------------------------------------------------------------------*/
/*
   --------------------------------------------------
   clear the data fields, releasing allocated storage

   created -- 97jun08, cca
   --------------------------------------------------
*/
void
DDenseMtx_clearData ( 
   DDenseMtx   *mtx 
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( mtx == NULL ) {
   fprintf(stderr, "\n fatal error in DDenseMtx_clearData(%p)"
           "\n bad input\n", mtx) ;
   exit(-1) ;
}
/*
   ------------------------
   free the working storage
   ------------------------
*/
DV_clearData(&mtx->wrkDV) ;
/*
   ----------------------
   set the default fields
   ----------------------
*/
DDenseMtx_setDefaultFields(mtx) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   ------------------------------------------
   destructor, free's the object and its data

   created -- 97jun08, cca
   ------------------------------------------
*/
void
DDenseMtx_free ( 
   DDenseMtx   *mtx 
) {
if ( mtx == NULL ) {
   fprintf(stderr, "\n fatal error in DDenseMtx_free(%p)"
           "\n bad input\n", mtx) ;
   exit(-1) ;
}
DDenseMtx_clearData(mtx) ;
FREE(mtx) ;

return ; }

/*--------------------------------------------------------------------*/
