/*  IO.c  */

#include "../DDenseMtx.h"

/*--------------------------------------------------------------------*/
/*
   -----------------------------------------------------
   purpose -- to write the object's statistics to a file
              in human readable form

   created -- 97jun08, cca
   -----------------------------------------------------
*/
void
DDenseMtx_writeStats (
   DDenseMtx   *mtx,
   FILE        *fp
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( mtx == NULL || fp == NULL ) {
   fprintf(stderr, "\n fatal error in DDenseMtx_writeStats(%p,%p)"
           "\n bad input\n", mtx, fp) ;
   exit(-1) ;
}
fprintf(fp, "\n DDenseMtx object at address %p"
        "\n row id = %d, col id = %d"
        "\n nrow = %d, ncol = %d, inc1 = %d, inc2 = %d",
        mtx, mtx->rowid, mtx->colid, 
        mtx->nrow, mtx->ncol, mtx->inc1, mtx->inc2) ;
fprintf(fp, "\n rowind = %p, colind = %p, entries = %p",
        mtx->rowind, mtx->colind, mtx->entries) ;
fprintf(fp, ", base = %p", DV_entries(&mtx->wrkDV)) ;
fprintf(fp, 
       "\n rowind - base = %d, colind - base = %d, entries - base = %d",
       mtx->rowind - (int *) DV_entries(&mtx->wrkDV),
       mtx->colind - (int *) DV_entries(&mtx->wrkDV),
       mtx->entries - DV_entries(&mtx->wrkDV)) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------------------------
   purpose -- to write the object to a file
              in human readable form

   created -- 97jun08, cca
   ----------------------------------------
*/
void
DDenseMtx_writeForHumanEye (
   DDenseMtx   *mtx,
   FILE        *fp
) {
DA2      da2 ;
int      ierr, ncol, nrow ;
int      *colind, *rowind ; 
/*
   ---------------
   check the input
   ---------------
*/
if ( mtx == NULL || fp == NULL ) {
   fprintf(stderr, "\n fatal error in DDenseMtx_writeForHumanEye(%p,%p)"
           "\n bad input\n", mtx, fp) ;
   exit(-1) ;
}
DDenseMtx_writeStats(mtx, fp) ;
DDenseMtx_rowIndices(mtx, &nrow, &rowind) ;
if ( nrow > 0 && rowind != NULL ) {
   fprintf(fp, "\n mtx's row indices at %p", rowind) ;
   IVfp80(fp, nrow, rowind, 80, &ierr) ;
}
DDenseMtx_columnIndices(mtx, &ncol, &colind) ;
if ( ncol > 0 && colind != NULL ) {
   fprintf(fp, "\n mtx's column indices at %p", colind) ;
   IVfp80(fp, ncol, colind, 80, &ierr) ;
}
if ( nrow > 0 && ncol > 0 ) {
   DA2_setDefaultFields(&da2) ;
   DDenseMtx_setDA2(mtx, &da2) ;
   DA2_writeForHumanEye(&da2, fp) ;
}
return ; }

/*--------------------------------------------------------------------*/
