/*  DDenseMtx   */

#include "../cfiles.h"
#include "../DA2.h"

/*--------------------------------------------------------------------*/
/*
   -------------------------------------------------------------------
   this object handles a dense matrix.

   rowid -- id for the rows in this matrix
   colid -- id for the columns in this matrix
   nrow  -- # of rows in the matrix
   ncol  -- # of columns in the matrix
   inc1  -- row increment for the entries
   inc2  -- column increment for the entries
   rowind  -- pointer to row indices
   colind  -- pointer to column indices
   entries -- pointer to matrix entries
   wrkDV   -- DV object to manage workspace
   next    -- pointer to next DDenseMtx object in a singly linked list
   -------------------------------------------------------------------
*/
typedef struct _DDenseMtx   DDenseMtx ;
struct _DDenseMtx {
   int         rowid    ;
   int         colid    ;
   int         nrow     ;
   int         ncol     ;
   int         inc1     ;
   int         inc2     ;
   int         *rowind  ;
   int         *colind  ;
   double      *entries ;
   DV          wrkDV    ;
   DDenseMtx   *next    ;
} ;
/*--------------------------------------------------------------------*/
/*
------------------------------------------------------------------------
----- methods found in basics.c ----------------------------------------
------------------------------------------------------------------------
*/
/*
   -----------------------
   simplest constructor
 
   created -- 97jun08, cca
   -----------------------
*/
DDenseMtx *
DDenseMtx_new ( 
   void 
) ;
/*
   -----------------------
   set the default fields
 
   created -- 97jun08, cca
   -----------------------
*/
void
DDenseMtx_setDefaultFields (
   DDenseMtx   *mtx
) ;
/*
   --------------------------------------------------
   clear the data fields, releasing allocated storage
 
   created -- 97jun08, cca
   --------------------------------------------------
*/
void
DDenseMtx_clearData (
   DDenseMtx   *mtx
) ;
/*
   ------------------------------------------
   destructor, free's the object and its data
 
   created -- 97jun08, cca
   ------------------------------------------
*/
void
DDenseMtx_free (
   DDenseMtx   *mtx
) ;
/*--------------------------------------------------------------------*/
/*
------------------------------------------------------------------------
----- methods found in instance.c --------------------------------------
------------------------------------------------------------------------
*/
/*
   -------------------------------
   return the row id of the object
 
   created -- 97jun08, cca
   -------------------------------
*/
int
DDenseMtx_rowid (
   DDenseMtx   *mtx
) ;
/*
   ----------------------------------
   return the column id of the object
 
   created -- 97jun08, cca
   ----------------------------------
*/
int
DDenseMtx_colid (
   DDenseMtx   *mtx
) ;
/*
   ------------------------------------------
   fill *pnrow with nrow and *pncol with ncol
 
   created -- 97jun08, cca
   ------------------------------------------
*/
void
DDenseMtx_dimensions (
   DDenseMtx   *mtx,
   int         *pnrow,
   int         *pncol
) ;
/*
   ------------------------
   return the row increment
 
   created -- 97jun18, cca
   ------------------------
*/
int
DDenseMtx_rowIncrement (
   DDenseMtx   *mtx
) ;
/*
   ---------------------------
   return the column increment
 
   created -- 97jun18, cca
   ---------------------------
*/
int
DDenseMtx_columnIncrement (
   DDenseMtx   *mtx
) ;
/*
   -------------------------------------------
   fill *pnrow with nrow, *prowind with rowind
 
   created -- 97jun08, cca
   -------------------------------------------
*/
void
DDenseMtx_rowIndices (
   DDenseMtx   *mtx,
   int         *pnrow,
   int         **prowind
) ;
/*
   -------------------------------------------
   fill *pncol with ncol, *pcolind with colind
 
   created -- 97jun08, cca
   -------------------------------------------
*/
void
DDenseMtx_columnIndices (
   DDenseMtx   *mtx,
   int         *pncol,
   int         **pcolind
) ;
/*
   --------------------------------------------
   fill *pentries with a pointer to the entries
 
   created -- 97jun08, cca
   --------------------------------------------
*/
double *
DDenseMtx_entries(
   DDenseMtx   *mtx
) ;
/*
   ---------------------------------
   return a pointer to the workspace
 
   created -- 97jun08, cca
   ---------------------------------
*/
void *
DDenseMtx_workspace(
   DDenseMtx   *mtx
) ;
/*--------------------------------------------------------------------*/
/*
------------------------------------------------------------------------
----- methods found in init.c ------------------------------------------
------------------------------------------------------------------------
*/
/*
   ------------------------------------------------------------
   return the number of bytes needed for an object of this size
 
   created -- 97aug15, cca
   ------------------------------------------------------------
*/
int
DDenseMtx_nbytesNeeded (
   int   nrow,
   int   ncol
) ;
/*
   ----------------------------------------------------------------
  return the number of bytes in the workspace owned by this object
 
   created -- 97jun08, cca
   ----------------------------------------------------------------
*/
int
DDenseMtx_nbytesInWorkspace (
   DDenseMtx   *mtx
) ;
/*
   -------------------------------------------------------------
   set the number of bytes in the workspace owned by this object
 
   created -- 97aug23, cca
   -------------------------------------------------------------
*/
void
DDenseMtx_setNbytesInWorkspace (
   DDenseMtx   *mtx,
   int         nbytes
) ;
/*
   ---------------------------------------
   purpose -- set the fields of the object
 
   created -- 97aug23, cca
   ---------------------------------------
*/
void
DDenseMtx_setFields (
   DDenseMtx   *mtx,
   int         rowid,
   int         colid,
   int         nrow,
   int         ncol,
   int         inc1,
   int         inc2
) ;
/*
   ----------------------------
   purpose -- basic initializer
 
   created -- 97jun08, cca
   ----------------------------
*/
void
DDenseMtx_init (
   DDenseMtx   *mtx,
   int         rowid,
   int         colid,
   int         nrow,
   int         ncol,
   int         inc1,
   int         inc2
) ;
/*
   ---------------------------------------------------------
   purpose -- initialize the object from its working storage
              used when the object is a MPI message
 
   created -- 97jul17, cca
   ---------------------------------------------------------
*/
void
DDenseMtx_initFromBuffer (
   DDenseMtx   *mtx
) ;
/*
   ------------------------------------
   purpose -- initializer with pointers
 
   created -- 97jun08, cca
   ------------------------------------
*/
void
DDenseMtx_initWithPointers (
   DDenseMtx   *mtx,
   int         rowid,
   int         colid,
   int         nrow,
   int         ncol,
   int         inc1,
   int         inc2,
   int         *rowind,
   int         *colind,
   double      *entries
) ;
/*
   ------------------------------------
   this method initializes a DA2 object
   to point into the entries
 
   created -- 97jun08, cca
   ------------------------------------
*/
void
DDenseMtx_setDA2 (
   DDenseMtx   *mtx,
   DA2         *da2
) ;
/*--------------------------------------------------------------------*/
/*
------------------------------------------------------------------------
----- methods found in IO.c --------------------------------------------
------------------------------------------------------------------------
*/
/*
   -----------------------------------------------------
   purpose -- to write the object's statistics to a file
              in human readable form
 
   created -- 97jun08, cca
   -----------------------------------------------------
*/
void
DDenseMtx_writeStats (
   DDenseMtx   *mtx,
   FILE        *fp
) ;
/*
   ----------------------------------------
   purpose -- to write the object to a file
              in human readable form
 
   created -- 97jun08, cca
   ----------------------------------------
*/
void
DDenseMtx_writeForHumanEye (
   DDenseMtx   *mtx,
   FILE        *fp
) ;
/*--------------------------------------------------------------------*/
/*
------------------------------------------------------------------------
----- methods found in util.c ------------------------------------------
------------------------------------------------------------------------
*/
/*
   ------------------------------------------------------------
   return the number of bytes needed for an object of this size
 
   created -- 97aug15, cca
   ------------------------------------------------------------
*/
int
DDenseMtx_nbytesNeeded (
   int   nrow,
   int   ncol
) ;
/*
   ----------------------------------------------------------------
  return the number of bytes in the workspace owned by this object
 
   created -- 97jun08, cca
   ----------------------------------------------------------------
*/
int
DDenseMtx_nbytesInWorkspace (
   DDenseMtx   *mtx
) ;
/*
   ---------------------------------------------------------
   sort the rows so the row ids are in ascending order
   sort the columns so the column ids are in ascending order
 
   created -- 97jul13, cca
   ---------------------------------------------------------
*/
void
DDenseMtx_sort (
   DDenseMtx   *mtx
) ;
/*
   -----------------------------------------------
   copy row irowA from mtxA into row irowB in mtxB
 
   created -- 97jul13, cca
   -----------------------------------------------
*/
void
DDenseMtx_copyRow (
   DDenseMtx   *mtxB,
   int         irowB,
   DDenseMtx   *mtxA,
   int         irowA
) ;
/*--------------------------------------------------------------------*/
