/*  util.c  */

#include "../DChvManager.h"

#define MYDEBUG 0

/*--------------------------------------------------------------------*/
/*
   ------------------------------------------
   return a pointer to a DChv object that has 
   been initialized with the input parameters

   created -- 97jul10, cca
   ------------------------------------------
*/
DChv *
DChvManager_newObjectOfSizeNbytes (
   DChvManager   *manager,
   int           nbytesNeeded
) {
DChv   *chv, *prev ;
int    nbytesAvailable, newinstance ;
/*
   ---------------
   check the input
   ---------------
*/
if ( manager == NULL || nbytesNeeded <= 0 ) {
   fprintf(stderr, 
           "\n fatal error in DChvMananger_newObjectOfSizeNbytes(%p,%d)"
           "\n bad input\n", manager, nbytesNeeded) ;
   exit(-1) ;
}
#if MYDEBUG > 0
fprintf(stdout, "\n\n %d bytes needed", nbytesNeeded) ;
fflush(stdout) ;
#endif
if ( manager->lock != NULL ) {
/*
   -----------------------------------------------
   lock the lock, get exclusive access to the list
   -----------------------------------------------
*/
#if MYDEBUG > 0
   fprintf(stdout, "\n manager: locking") ;
   fflush(stdout) ;
#endif
   Lock_lock(manager->lock) ;
   manager->nlocks++ ;
#if MYDEBUG > 0
   fprintf(stdout, ", %d locks so far", manager->nlocks) ;
   fflush(stdout) ;
#endif
}
/*
   ----------------------------------------------------
   find a DChv object with the required number of bytes
   ----------------------------------------------------
*/
for ( chv = manager->head, prev = NULL ; 
      chv != NULL ; 
      chv = chv->next ) {
   nbytesAvailable = DChv_nbytesInWorkspace(chv) ;
#if MYDEBUG > 0
   fprintf(stdout, "\n free chev %p, nbytes = %d",
           chv, nbytesAvailable) ;
   fflush(stdout) ;
#endif
   if ( nbytesNeeded <= nbytesAvailable ) {
      break ;
   }
   prev = chv ;
}
if ( chv != NULL ) {
/*
   ---------------------------------------
   suitable object found, remove from list
   ---------------------------------------
*/
#if MYDEBUG > 0
   fprintf(stdout, "\n chv = %p, %d nbytes available",
           chv, nbytesAvailable) ;
   fflush(stdout) ;
#endif
   if ( prev == NULL ) {
      manager->head = chv->next ;
   } else {
      prev->next = chv->next ;
   }
   newinstance = 0 ;
} else {
/*
   ------------------------------------------------------------------
   no suitable object found, create new instance and allocate storage
   ------------------------------------------------------------------
*/
   chv = DChv_new() ;
   manager->nactive++ ;
#if MYDEBUG > 0
   fprintf(stdout, "\n new postponed chv = %p", chv) ;
   fflush(stdout) ;
#endif
   newinstance = 1 ;
   DV_setSize(&chv->wrkDV, nbytesNeeded/sizeof(double)) ;
}
/*
   -------------------------------
   increment the statistics fields
   -------------------------------
*/
if ( newinstance == 1 ) {
   manager->nbytesactive += nbytesNeeded ;
}
manager->nbytesrequested += nbytesNeeded ;
#if MYDEBUG > 0
fprintf(stdout, "\n %d bytes active, %d bytes requested",
        manager->nbytesactive, manager->nbytesrequested) ;
#endif
manager->nrequests++ ;
if ( manager->lock != NULL ) {
/*
   -----------------------------------------------------
   unlock the lock, release exclusive access to the list
   -----------------------------------------------------
*/
   manager->nunlocks++ ;
   Lock_unlock(manager->lock) ;
#if MYDEBUG > 0
   fprintf(stdout, "\n manager: unlocking, %d unlocks so far",
           manager->nunlocks) ;
   fflush(stdout) ;
#endif
}
return(chv) ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------
   release a DChv instance

   created -- 97may24, cca
   -----------------------
*/
void
DChvManager_releaseObject (
   DChvManager   *manager,
   DChv          *chv1
) {
DChv   *chv2, *prev ;
int    nbytes1, nbytes2 ;
/*
   ---------------
   check the input
   ---------------
*/
if ( manager == NULL ) {
   fprintf(stderr, 
           "\n fatal error in DChvMananger_releaseObject(%p,%p)"
           "\n bad input\n", manager, chv1) ;
   exit(-1) ;
}

if ( manager->lock != NULL ) {
/*
   -----------------------------------------------
   lock the lock, get exclusive access to the list
   -----------------------------------------------
*/
   Lock_lock(manager->lock) ;
   manager->nlocks++ ;
}
/*
   --------------------------------------------------------
   find a place in the list where the DChv objects are 
   sorted in ascending order of the size of their workspace
   --------------------------------------------------------
*/
nbytes1 = DChv_nbytesInWorkspace(chv1) ;
#if MYDEBUG > 0
fprintf(stdout, "\n\n trying to release chevron %p with %d bytes",
        chv1, nbytes1) ;
#endif
for ( chv2 = manager->head, prev = NULL ; 
      chv2 != NULL ; 
      chv2 = chv2->next ) {
   nbytes2 = DChv_nbytesInWorkspace(chv2) ;
#if MYDEBUG > 0
   fprintf(stdout, "\n list chevron %p with %d bytes", chv2, nbytes2) ;
#endif
   if ( nbytes2 > nbytes1 ) {
      break ;
   }
   prev = chv2 ;
}
if ( prev == NULL ) {
   manager->head = chv1 ;
#if MYDEBUG > 0
   fprintf(stdout, "\n manager->head = %p", chv1) ;
#endif
} else {
   prev->next = chv1 ;
#if MYDEBUG > 0
   fprintf(stdout, "\n %p->next = %p", prev, chv1) ;
#endif
}
chv1->next = chv2 ;
#if MYDEBUG > 0
fprintf(stdout, "\n %p->next = %p", chv1, chv2) ;
#endif
manager->nreleases++ ;
if ( manager->lock != NULL ) {
/*
   -----------------------------------------------------
   unlock the lock, release exclusive access to the list
   -----------------------------------------------------
*/
   manager->nunlocks++ ;
   Lock_unlock(manager->lock) ;
}
return ; }

/*--------------------------------------------------------------------*/
/*
   ------------------------------
   release a list of DChv objects

   created -- 97may29, cca
   ------------------------------
*/
void
DChvManager_releaseListOfObjects (
   DChvManager   *manager,
   DChv          *head
) {
DChv   *chv1, *chv2, *prev ;
int    nbytes1, nbytes2 ;

if ( manager->lock != NULL ) {
/*
   -----------------------------------------------
   lock the lock, get exclusive access to the list
   -----------------------------------------------
*/
   Lock_lock(manager->lock) ;
   manager->nlocks++ ;
}
while ( head != NULL ) {
   chv1 = head ;
   head = chv1->next ;
/*
   --------------------------------------------------------
   find a place in the list where the DChv objects are 
   sorted in ascending order of the size of their workspace
   --------------------------------------------------------
*/
   nbytes1 = DChv_nbytesInWorkspace(chv1) ;
#if MYDEBUG > 0
   fprintf(stdout, "\n\n trying to release chevron %p with %d bytes",
           chv1, nbytes1) ;
#endif
   for ( chv2 = manager->head, prev = NULL ; 
         chv2 != NULL ; 
         chv2 = chv2->next ) {
      nbytes2 = DChv_nbytesInWorkspace(chv2) ;
#if MYDEBUG > 0
      fprintf(stdout, 
              "\n list chevron %p with %d bytes", chv2, nbytes2) ;
#endif
      if ( nbytes2 > nbytes1 ) {
         break ;
      }
      prev = chv2 ;
   }
   if ( prev == NULL ) {
      manager->head = chv1 ;
#if MYDEBUG > 0
      fprintf(stdout, "\n manager->head = %p", chv1) ;
#endif
   } else {
      prev->next = chv1 ;
#if MYDEBUG > 0
      fprintf(stdout, "\n %p->next = %p", prev, chv1) ;
#endif
   }
   chv1->next = chv2 ;
#if MYDEBUG > 0
   fprintf(stdout, "\n %p->next = %p", chv1, chv2) ;
#endif
   manager->nreleases++ ;
}
if ( manager->lock != NULL ) {
/*
   -----------------------------------------------------
   unlock the lock, release exclusive access to the list
   -----------------------------------------------------
*/
   manager->nunlocks++ ;
   Lock_unlock(manager->lock) ;
}
return ; }

/*--------------------------------------------------------------------*/
