/*  init.c  */

#include "../DChvManager.h"

/*--------------------------------------------------------------------*/
/*
   ---------------------------------------------------------------
   simple initializer

   lockflag = 0 --> mutex lock is not allocated or initialized
   lockflag = 1 --> mutex lock is allocated and it can synchronize
                    omly threads in this process.
   lockflag = 2 --> mutex lock is allocated and it can synchronize
                    omly threads in this and other processes.
                        
   created -- 97may24, cca
   ---------------------------------------------------------------
*/
void
DChvManager_init (
   DChvManager   *manager,
   int           lockflag
) {
/*
   --------------------------------------------------
   clear any previous data and set the default fields
   --------------------------------------------------
*/
DChvManager_clearData(manager) ;
if ( lockflag > 0 ) {
/*
   ---------------------------
   initialize the mutex object
   ---------------------------
*/
   manager->lock = Lock_new() ;
   Lock_init(manager->lock, lockflag) ;
}
return ; }

/*--------------------------------------------------------------------*/
