/*  basics.c  */

#include "../DChvManager.h"

#define   MYDEBUG 0

/*--------------------------------------------------------------------*/
/*
   -----------------------
   simplest constructor

   created -- 97may24, cca
   -----------------------
*/
DChvManager *
DChvManager_new ( 
   void 
) {
DChvManager   *manager ;

ALLOCATE(manager, struct _DChvManager, 1) ;
DChvManager_setDefaultFields(manager) ;

return(manager) ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------
   set the default fields

   created -- 97may24, cca
   -----------------------
*/
void
DChvManager_setDefaultFields (
   DChvManager   *manager
) {
if ( manager == NULL ) {
   fprintf(stderr, "\n fatal error in DChvManager_setDefaultFields(%p)"
           "\n bad input", manager) ;
   exit(-1) ;
}
manager->head            = NULL ;
manager->lock            = NULL ;
manager->nactive         =   0  ;
manager->nbytesactive    =   0  ;
manager->nbytesrequested =   0  ;
manager->nrequests       =   0  ;
manager->nreleases       =   0  ;
manager->nlocks          =   0  ;
manager->nunlocks        =   0  ;

return ; }

/*--------------------------------------------------------------------*/
/*
   --------------------------------------------------
   clear the data fields, releasing allocated storage

   created -- 97may24, cca
   --------------------------------------------------
*/
void
DChvManager_clearData ( 
   DChvManager   *manager 
) {
DChv   *chv ;
/*
   ---------------
   check the input
   ---------------
*/
if ( manager == NULL ) {
   fprintf(stderr, "\n fatal error in DChvManager_clearData(%p)"
           "\n bad input\n", manager) ;
   exit(-1) ;
}
/*
   ------------------------
   free the working storage
   ------------------------
*/
while ( (chv = manager->head) != NULL ) {
   manager->head = chv->next ;
   DChv_free(chv) ;
}
if ( manager->lock != NULL ) {
/*
   -------------------------
   destroy and free the lock
   -------------------------
*/
   Lock_free(manager->lock) ;
}
/*
   ----------------------
   set the default fields
   ----------------------
*/
DChvManager_setDefaultFields(manager) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   ------------------------------------------
   destructor, free's the object and its data

   created -- 97may24, cca
   ------------------------------------------
*/
void
DChvManager_free ( 
   DChvManager   *manager 
) {
if ( manager == NULL ) {
   fprintf(stderr, "\n fatal error in DChvManager_free(%p)"
           "\n bad input\n", manager) ;
   exit(-1) ;
}
DChvManager_clearData(manager) ;
FREE(manager) ;

return ; }

/*--------------------------------------------------------------------*/
