/*  DChvManager.h  */

#include "../DChv.h"
#include "../Lock.h"
 
/*--------------------------------------------------------------------*/
/*
*/
typedef struct _DChvManager  DChvManager ;
struct _DChvManager {
   DChv      *head           ;
   Lock      *lock           ;
   int       nactive         ;
   int       nbytesactive    ;
   int       nbytesrequested ;
   int       nrequests       ;
   int       nreleases       ;
   int       nlocks          ;
   int       nunlocks        ;
} ;
/*--------------------------------------------------------------------*/
/*
------------------------------------------------------------------------
----- methods found in basics.c ----------------------------------------
------------------------------------------------------------------------
*/
/*
   -----------------------
   simplest constructor
 
   created -- 97may24, cca
   -----------------------
*/
DChvManager *
DChvManager_new ( 
   void 
) ;
/*
   -----------------------
   set the default fields
 
   created -- 97may24, cca
   -----------------------
*/
void
DChvManager_setDefaultFields (
   DChvManager   *manager
) ;
/*
   --------------------------------------------------
   clear the data fields, releasing allocated storage
 
   created -- 97may24, cca
   --------------------------------------------------
*/
void
DChvManager_clearData (
   DChvManager   *manager
) ;
/*
   ------------------------------------------
   destructor, free's the object and its data
 
   created -- 97may24, cca
   ------------------------------------------
*/
void
DChvManager_free (
   DChvManager   *manager
) ;
/*--------------------------------------------------------------------*/
/*
------------------------------------------------------------------------
----- methods found in init.c ------------------------------------------
------------------------------------------------------------------------
*/
/*
   ---------------------------------------------------------------
   simple initializer
 
   lockflag = 0 --> mutex lock is not allocated or initialized
   lockflag = 1 --> mutex lock is allocated and it can synchronize
                    only threads in this process.
   lockflag = 2 --> mutex lock is allocated and it can synchronize
                    only threads in this and other processes.
                                
   created -- 97may24, cca
   ---------------------------------------------------------------
*/
void
DChvManager_init (
   DChvManager   *manager,
   int           lockflag
) ;
/*--------------------------------------------------------------------*/
/*
------------------------------------------------------------------------
----- methods found in util.c ------------------------------------------
------------------------------------------------------------------------
*/
/*
   ------------------------------------------
   return a pointer to a DChv object that has 
   been initialized with the input parameters
 
   created -- 97may24, cca
   ------------------------------------------
*/
DChv *
DChvManager_newObject (
   DChvManager   *manager,
   int           id,
   int           nD,
   int           nL,
   int           nU,
   int           symflag
) ;
/*
   ------------------------------------------
   return a pointer to a DChv object that has 
   been initialized with the input parameters
 
   created -- 97jul10, cca
   ------------------------------------------
*/
DChv *
DChvManager_newObjectOfSizeNbytes (
   DChvManager   *manager,
   int           nbytesNeeded
) ;
/*
   -----------------------
   release a DChv instance
 
   created -- 97may24, cca
   -----------------------
*/
void
DChvManager_releaseObject (
   DChvManager   *manager,
   DChv          *chv
) ;
/*
   ------------------------------
   release a list of DChv objects
 
   created -- 97may29, cca
   ------------------------------
*/
void
DChvManager_releaseListOfObjects (
   DChvManager   *manager,
   DChv          *head
) ;
/*--------------------------------------------------------------------*/
/*
------------------------------------------------------------------------
----- methods found in IO.c --------------------------------------------
------------------------------------------------------------------------
*/
/*
   ----------------------------------------
   purpose -- to write the object to a file
              in human readable form
 
   created -- 97may24, cca
   ----------------------------------------
*/
void
DChvManager_writeForHumanEye (
   DChvManager   *manager,
   FILE     *fp
) ;
/*--------------------------------------------------------------------*/
