/*  util.c  */

#include "../DChvList.h"

#define MYDEBUG 0

/*--------------------------------------------------------------------*/
/*
   -----------------------------------
   return 1 if list ilist is not empty
   return 0 if list ilist is empty

   created -- 97may24, cca
   -----------------------------------
*/
int
DChvList_isListNonempty (
   DChvList   *chvlist,
   int        ilist
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( chvlist == NULL || ilist < 0 || ilist >= chvlist->nlist ) {
   fprintf(stderr, "\n fatal error in DChvList_isListNonempty(%p,%d)"
           "\n bad input\n", chvlist, ilist) ;
}
return(chvlist->heads[ilist] != NULL) ; }

/*--------------------------------------------------------------------*/
/*
   ---------------------------------------------------------
   return 1 if the count for list ilist is zero
   return 0 if the count for list ilist is greater than zero

   created -- 97may24, cca
   ---------------------------------------------------------
*/
int
DChvList_isCountZero (
   DChvList   *chvlist,
   int        ilist
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( chvlist == NULL || ilist < 0 || ilist >= chvlist->nlist ) {
   fprintf(stderr, "\n fatal error in DChvList_isCountZero(%p,%d)"
           "\n bad input\n", chvlist, ilist) ;
}
if ( chvlist->counts == NULL ) {
   return(0) ;
} else {
   return(chvlist->counts[ilist] == 0) ;
}
}

/*--------------------------------------------------------------------*/
/*
   ---------------------------------------------------------
   return 1 if the count for list ilist is zero
   return 0 if the count for list ilist is greater than zero

   created -- 97may24, cca
   ---------------------------------------------------------
*/
void
DChvList_addObjectToList (
   DChvList   *chvlist,
   DChv       *chv,
   int        ilist
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( chvlist == NULL || ilist < 0 || ilist >= chvlist->nlist ) {
   fprintf(stderr, 
           "\n fatal error in DChvList_addObjectToList(%p,%p,%d)"
           "\n bad input\n", chvlist, chv, ilist) ;
   exit(-1) ;
}
#if MYDEBUG > 0
fprintf(stdout, "\n DChvList %p : adding chv %p to list %d",
        chvlist, chv, ilist) ;
fflush(stdout) ;
#endif
if ( chvlist->lock != NULL
   && (chvlist->flags == NULL || chvlist->flags[ilist] == 'Y' ) ) {
/*
   --------------------------------------------------
   we must lock the list to (possibly) add the object
   and decrement the list's count
   --------------------------------------------------
*/
   Lock_lock(chvlist->lock) ;
   if ( chv != NULL ) {
      chv->next = chvlist->heads[ilist] ;
      chvlist->heads[ilist] = chv ;
   }
   if ( chvlist->counts != NULL ) {
      chvlist->counts[ilist]-- ;
   }
   chvlist->nlocks++ ;
   Lock_unlock(chvlist->lock) ;
} else {
/*
   ---------------------------------------------
   no need to lock the list, just (possibly)
   add the object and decrement the list's count
   ---------------------------------------------
*/
   if ( chv != NULL ) {
      chv->next = chvlist->heads[ilist] ;
      chvlist->heads[ilist] = chv ;
   }
   if ( chvlist->counts != NULL ) {
      chvlist->counts[ilist]-- ;
   }
}
#if MYDEBUG > 0
fprintf(stdout, "\n DChvList %p : heads[%d] = %p, counts[%d] = %d",
        chvlist, ilist, chvlist->heads[ilist],
        ilist, chvlist->counts[ilist]) ;
fflush(stdout) ;
#endif
return ; }

/*--------------------------------------------------------------------*/
/*
   ------------------------------------
   return pointer to head of list ilist
   and set head to NULL

   created -- 97may24, cca
   ------------------------------------
*/
DChv *
DChvList_getList (
   DChvList   *chvlist,
   int        ilist
) {
DChv   *chv ;
/*
   ---------------
   check the input
   ---------------
*/
if ( chvlist == NULL || ilist < 0 || ilist >= chvlist->nlist ) {
   fprintf(stderr, 
           "\n fatal error in DChvList_getList(%p,%d)"
           "\n bad input\n", chvlist, ilist) ;
   exit(-1) ;
}
#if MYDEBUG > 0
fprintf(stdout, "\n DChvList %p : get list %d", chvlist, ilist) ;
fflush(stdout) ;
#endif
if ( chvlist->heads[ilist] != NULL ) {
   if ( chvlist->lock == NULL
     || (chvlist->flags != NULL && chvlist->flags[ilist] == 'N')
     || (chvlist->counts != NULL && chvlist->counts[ilist] == 0) ) {
/*
      ------------------------
      no need to lock the list
      ------------------------
*/
      chv = chvlist->heads[ilist] ;
      chvlist->heads[ilist] = NULL ;
   } else {
/*
      ----------------------------------------------------
      we must lock the list to return the head of the list
      ----------------------------------------------------
*/
      Lock_lock(chvlist->lock) ;
      chv = chvlist->heads[ilist] ;
      chvlist->heads[ilist] = NULL ;
      chvlist->nlocks++ ;
      Lock_unlock(chvlist->lock) ;
   }
} else {
   chv = NULL ;
}
#if MYDEBUG > 0
fprintf(stdout, "\n DChvList %p : chv %p", chvlist, chv) ;
fflush(stdout) ;
#endif
return(chv) ; }

/*--------------------------------------------------------------------*/
