/*  basics.c  */

#include "../DChvList.h"

#define   MYDEBUG 0

/*--------------------------------------------------------------------*/
/*
   -----------------------
   simplest constructor

   created -- 97may24, cca
   -----------------------
*/
DChvList *
DChvList_new ( 
   void 
) {
DChvList   *chvlist ;

ALLOCATE(chvlist, struct _DChvList, 1) ;
DChvList_setDefaultFields(chvlist) ;

return(chvlist) ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------
   set the default fields

   created -- 97may24, cca
   -----------------------
*/
void
DChvList_setDefaultFields (
   DChvList   *chvlist
) {
if ( chvlist == NULL ) {
   fprintf(stderr, "\n fatal error in DChvList_setDefaultFields(%p)"
           "\n bad input", chvlist) ;
   exit(-1) ;
}
chvlist->nlist  =   0  ;
chvlist->heads  = NULL ;
chvlist->counts = NULL ;
chvlist->lock   = NULL ;
chvlist->flags  = NULL ;
chvlist->nlocks =   0  ;

return ; }

/*--------------------------------------------------------------------*/
/*
   --------------------------------------------------
   clear the data fields, releasing allocated storage

   created -- 97may24, cca
   --------------------------------------------------
*/
void
DChvList_clearData ( 
   DChvList   *chvlist 
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( chvlist == NULL ) {
   fprintf(stderr, "\n fatal error in DChvList_clearData(%p)"
           "\n bad input\n", chvlist) ;
   exit(-1) ;
}
/*
   -------------
   free the data
   -------------
*/
if ( chvlist->heads != NULL ) {
   FREE(chvlist->heads) ;
}
if ( chvlist->counts != NULL ) {
   IVfree(chvlist->counts) ;
}
if ( chvlist->flags != NULL ) {
   CVfree(chvlist->flags) ;
}
if ( chvlist->lock != NULL ) {
/*
   -------------------------
   destroy and free the lock
   -------------------------
*/
   Lock_free(chvlist->lock) ;
}
/*
   ----------------------
   set the default fields
   ----------------------
*/
DChvList_setDefaultFields(chvlist) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   ------------------------------------------
   destructor, free's the object and its data

   created -- 97may24, cca
   ------------------------------------------
*/
void
DChvList_free ( 
   DChvList   *chvlist 
) {
if ( chvlist == NULL ) {
   fprintf(stderr, "\n fatal error in DChvList_free(%p)"
           "\n bad input\n", chvlist) ;
   exit(-1) ;
}
DChvList_clearData(chvlist) ;
FREE(chvlist) ;

return ; }

/*--------------------------------------------------------------------*/
