/*  init.c  */

#include "../DChv.h"

#define MYDEBUG 0

/*--------------------------------------------------------------------*/
/*
   ------------------------------------------------------
   return the number of bytes needed to store the chevron

   created -- 97jul03, cca
   ------------------------------------------------------
*/
int
DChv_nbytesNeeded (
   int   nD,
   int   nL,
   int   nU,
   int   symflag
) {
int   nbytes, nent, nint ;
/*
   --------------
   check the data
   --------------
*/
if ( nD < 0 || nL < 0 || nU < 0 || symflag < 0 || symflag > 2 ) {
   fprintf(stderr, "\n fatal error in DChv_nbytesNeeded(%d,%d,%d,%d)"
           "\n bad input\n", nD, nL, nU, symflag) ;
   exit(-1) ;
}
switch ( symflag ) {
case 0 :
   nint = 5 + nD + nU ;
   nent = (nD*(nD+1))/2 + nD*nU ;
   break ;
case 1:
   nint = 5 + nD + nU ;
   nent = nD*(nD + 2*nU) ;
   break ;
case 2 :
   nint = 5 + 2*nD + nL + nU ;
   nent = nD*(nD + nL + nU) ;
   break ;
default :
   fprintf(stderr, "\n fatal error in DChv_nbytesNeeded(%d,%d,%d,%d)"
           "\n symflag = %d, must be 0, 1 or 2\n",
           nD, nL, nU, symflag, symflag) ;
   exit(-1) ;
}
if ( 2*sizeof(int) == sizeof(double) ) {
   nbytes = ((nint + 1)/2 + nent)*sizeof(double) ;
} else if ( sizeof(int) == sizeof(double) ) {
   nbytes = (nint + nent)*sizeof(double) ;
} else {
   fprintf(stderr, "\n fatal error in DChv_nbytesNeeded(%d,%d,%d,%d)"
           "\n sizeof(int) = %d, sizeof(double) = %d",
           nD, nL, nU, symflag, sizeof(int), sizeof(double)) ;
   exit(-1) ;
}
return(nbytes) ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------------------------------------------------
   return the number of bytes in the workspace owned by this object

   created -- 97may24, cca
   ----------------------------------------------------------------
*/
int
DChv_nbytesInWorkspace (
   DChv   *chv
) {
if ( chv == NULL ) {
   fprintf(stderr, "\n fatal error in DChv_nbytesInWorkspace(%p)"
           "\n bad input\n", chv) ;
   exit(-1) ;
}
return(sizeof(double)*DV_maxsize(&chv->wrkDV)) ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------------------------------------------------
   set the number of bytes in the workspace owned by this object

   created -- 97aug21, cca
   ----------------------------------------------------------------
*/
void
DChv_setNbytesInWorkspace (
   DChv   *chv,
   int    nbytes
) {
if ( chv == NULL ) {
   fprintf(stderr, "\n fatal error in DChv_setNbytesInWorkspace(%p,%d)"
           "\n bad input\n", chv, nbytes) ;
   exit(-1) ;
}
DV_setSize(&chv->wrkDV, nbytes/sizeof(double)) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------------
   purpose -- set the fields

   created -- 97aug21, cca
   ----------------------------
*/
void
DChv_setFields (
   DChv     *chv,
   int      id,
   int      nD,
   int      nL,
   int      nU,
   int      symflag
) {
double   *dbuffer ;
int      nint     ;
int      *ibuffer ;
/*
   ---------------
   check the input
   ---------------
*/
if (  chv == NULL || nD <= 0 || nL < 0 || nU < 0 
   || symflag < 0 || symflag > 2 ) {
   fprintf(stderr, 
           "\n fatal error in DChv_setFields(%p,%d,%d,%d,%d,%d)"
           "\n bad input\n", chv, id, nD, nL, nU, symflag) ;
   exit(-1) ;
}
dbuffer = DV_entries(&chv->wrkDV) ;
ibuffer = (int *) dbuffer ;
/*
   ---------------------
   set the scalar fields
   ---------------------
*/
chv->id      = ibuffer[0] = id      ;
chv->nD      = ibuffer[1] = nD      ;
chv->nL      = ibuffer[2] = nL      ;
chv->nU      = ibuffer[3] = nU      ;
chv->symflag = ibuffer[4] = symflag ;
/*
   -------------------------------------------
   set the colind, rowind and entries pointers
   -------------------------------------------
*/
chv->colind = ibuffer + 5 ;
nint = 5 + nD + nU ;
if ( symflag == 2 ) {
   chv->rowind = chv->colind + nD + nU ;
   nint += nD + nL ;
} else {
   chv->rowind = NULL ;
}
if ( sizeof(int) == sizeof(double) ) {
   chv->entries = dbuffer + nint ;
} else if ( 2*sizeof(int) == sizeof(double) ) {
   chv->entries = dbuffer + (nint + 1)/2 ;
}
return ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------------
   purpose -- basic initializer

   created -- 97apr23, cca
   ----------------------------
*/
void
DChv_init (
   DChv     *chv,
   int      id,
   int      nD,
   int      nL,
   int      nU,
   int      symflag
) {
int      nbytes ;
/*
   ---------------
   check the input
   ---------------
*/
if (  chv == NULL || nD <= 0 || nL < 0 || nU < 0 
   || symflag < 0 || symflag > 2 ) {
   fprintf(stderr, 
           "\n fatal error in DChv_init(%p,%d,%d,%d,%d,%d)"
           "\n bad input\n", chv, id, nD, nL, nU, symflag) ;
   exit(-1) ;
}
/*
   -------------------------------------------------------
   get and set the number of bytes needed in the workspace
   -------------------------------------------------------
*/
nbytes = DChv_nbytesNeeded(nD, nL, nU, symflag) ;
DChv_setNbytesInWorkspace(chv, nbytes) ;
/*
   --------------
   set the fields
   --------------
*/
DChv_setFields(chv, id, nD, nL, nU, symflag) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   ------------------------------------
   purpose -- initializer with pointers

   created -- 97apr23, cca
   ------------------------------------
*/
void
DChv_initWithPointers (
   DChv     *chv,
   int      id,
   int      nD,
   int      nL,
   int      nU,
   int      symflag,
   int      *rowind,
   int      *colind,
   double   *entries
) {
/*
   ---------------
   check the input
   ---------------
*/
if (  chv == NULL || nD <= 0 || nL < 0 || nU < 0 
   || symflag < 0 || symflag > 2 ) {
   fprintf(stderr, 
           "\n fatal error in DChv_init(%p,%d,%d,%d,%d,%d,%p,%p,%p)"
           "\n bad input\n",
           chv, id, nD, nL, nU, symflag, rowind, colind, entries) ;
   exit(-1) ;
}
if (  entries == NULL || colind == NULL 
   || (symflag == 2 && rowind == NULL) ) {
   fprintf(stderr, 
           "\n fatal error in DChv_init(%p,%d,%d,%d,%d,%d,%p,%p,%p)"
           "\n entries = %p, colind = %p, rowind = %p, symflag = %d\n",
           chv, id, nD, nL, nU, symflag, rowind, colind, entries,
           entries, colind, rowind, symflag) ;
   exit(-1) ;
}
/*
   ---------------------
   set the scalar fields
   ---------------------
*/
chv->id      = id      ;
chv->nD      = nD      ;
chv->nL      = nL      ;
chv->nU      = nU      ;
chv->symflag = symflag ;
/*
   --------------------------
   set up the working storage
   --------------------------
*/
chv->entries = entries ;
chv->colind  = colind  ;
if ( symflag == 2 ) {
   chv->rowind = rowind ;
} else {
   chv->rowind = NULL ;
}
return ; }

/*--------------------------------------------------------------------*/
/*
   -------------------------------------------------------------
   purpose -- to initialize the object from its working storage,
              used when the object is an MPI message

   created -- 97jul18
   -------------------------------------------------------------
*/
void
DChv_initFromBuffer (
   DChv   *chv
) {
int      *ibuffer ;
/*
   ---------------
   check the input
   ---------------
*/
if (  chv == NULL ) {
   fprintf(stderr, "\n fatal error in DChv_initFromBuffer(%p) "
           "\n bad input\n", chv) ;
   exit(-1) ;
}
ibuffer = (int *) DV_entries(&chv->wrkDV) ;
DChv_setFields(chv, ibuffer[0], ibuffer[1], ibuffer[2], 
               ibuffer[3], ibuffer[4]) ;

return ; }

/*--------------------------------------------------------------------*/
