/*  fill.c  */

#include "../DChv.h"

#define MYDEBUG 0

/*--------------------------------------------------------------------*/
/*
   --------------------------------
   fill DA2 object with (1,1) block

   created -- 97apr24, cca
   --------------------------------
*/
void
DChv_fill11block (
   DChv   *chv,
   DA2    *mtx
) {
double   *entries ;
int      nD, nL, nU ;
/*
   ---------------
   check the input
   ---------------
*/
if ( chv == NULL || mtx == NULL ) {
   fprintf(stderr, "\n fatal error in DChv_fill11block(%p,%p)"
           "\n bad input\n", chv, mtx) ;
   exit(-1) ;
}
nD      = chv->nD      ;
nL      = chv->nL      ;
nU      = chv->nU      ;
entries = chv->entries ;
/*
   ----------------------------------
   resize the DA2 object as necessary
   ----------------------------------
*/
DA2_resize(mtx, nD, nD, 1, nD) ;
DA2_zero(mtx) ;
if ( chv->symflag == 0 ) {
   int   ii, iioff, ioff, istride, jj ;
/*
   ------------------
   chv is symmetric
   ------------------
*/
   ioff = 0 ;
   istride = nD + nU ;
   for ( ii = 0 ; ii < nD ; ii++ ) {
      DA2_setEntry(mtx, ii, ii, entries[ioff]) ;
      for ( jj = ii + 1, iioff = ioff + 1 ; 
            jj < nD ; 
            jj++, iioff++ ) {
         DA2_setEntry(mtx, ii, jj, entries[iioff]) ;
         DA2_setEntry(mtx, jj, ii, 0.0) ;
      }
      ioff += istride ;
      istride-- ;
   }
} else {
   int   ii, iioff, ioff, istride, jj ;
/*
   ---------------------
   chv is nonsymmetric
   ---------------------
*/
   ioff = nD + nL - 1 ;
   istride = 2*nD + nU + nL - 2 ;
   for ( ii = 0 ; ii < nD ; ii++ ) {
#if MYDEBUG > 0
      fprintf(stdout, "\n ii %d, ioff %d, setting (%d,%d) = %20.12e",
              ii, ioff, ii, ii, entries[ioff]) ;
#endif
      DA2_setEntry(mtx, ii, ii, entries[ioff]) ;
      for ( jj = ii + 1, iioff = ioff + 1 ; 
            jj < nD ; 
            jj++, iioff++ ) {
#if MYDEBUG > 0
         fprintf(stdout, 
                 "\n jj %d, iioff %d, setting (%d,%d) = %20.12e",
                 jj, iioff, ii, ii, entries[iioff]) ;
#endif
         DA2_setEntry(mtx, ii, jj, entries[iioff]) ;
      }
      for ( jj = ii + 1, iioff = ioff - 1 ; 
            jj < nD ; 
            jj++, iioff-- ) {
#if MYDEBUG > 0
         fprintf(stdout, 
                 "\n jj %d, iioff %d, setting (%d,%d) = %20.12e",
                 jj, iioff, ii, ii, entries[iioff]) ;
#endif
         DA2_setEntry(mtx, jj, ii, entries[iioff]) ;
      }
      ioff += istride ;
      istride -= 2 ;
   }
}
return ; }

/*--------------------------------------------------------------------*/
/*
   --------------------------------
   fill DA2 object with (1,2) block

   created -- 97apr24, cca
   --------------------------------
*/
void
DChv_fill12block (
   DChv   *chv,
   DA2    *mtx
) {
double   *entries ;
int      nD, nL, nU ;
/*
   ---------------
   check the input
   ---------------
*/
if ( chv == NULL || mtx == NULL ) {
   fprintf(stderr, "\n fatal error in DChv_fill12block(%p,%p)"
           "\n bad input\n", chv, mtx) ;
   exit(-1) ;
}
nD      = chv->nD      ;
nL      = chv->nL      ;
nU      = chv->nU      ;
entries = chv->entries ;
/*
   ----------------------------------
   resize the DA2 object as necessary
   ----------------------------------
*/
DA2_resize(mtx, nD, nU, 1, nD) ;
DA2_zero(mtx) ;
if ( chv->symflag == 0 ) {
   int   ii, iioff, ioff, istride, jj ;
/*
   ------------------
   chv is symmetric
   ------------------
*/
   ioff = 0 ;
   istride = nD + nU ;
   for ( ii = 0 ; ii < nD ; ii++ ) {
      for ( jj = 0, iioff = ioff + nD - ii ; 
            jj < nU ; 
            jj++, iioff++ ) {
         DA2_setEntry(mtx, ii, jj, entries[iioff]) ;
      }
      ioff += istride ;
      istride-- ;
   }
} else {
   int   ii, iioff, ioff, istride, jj ;
/*
   ---------------------
   chv is nonsymmetric
   ---------------------
*/
   ioff = nD + nL - 1 ;
   istride = 2*nD + nU + nL - 2 ;
   for ( ii = 0 ; ii < nD ; ii++ ) {
      for ( jj = 0, iioff = ioff + nD - ii ; 
            jj < nU ; 
            jj++, iioff++ ) {
#if MYDEBUG > 0
         fprintf(stdout, 
             "\n 21: ii %d, jj %d, iioff %d, setting (%d,%d) = %20.12e",
              ii, jj, iioff, ii, ii, entries[iioff]) ;
#endif
         DA2_setEntry(mtx, ii, jj, entries[iioff]) ;
      }
      ioff += istride ;
      istride -= 2 ;
   }
}
return ; }

/*--------------------------------------------------------------------*/
/*
   --------------------------------
   fill DA2 object with (2,1) block

   created -- 97apr24, cca
   --------------------------------
*/
void
DChv_fill21block (
   DChv   *chv,
   DA2    *mtx
) {
double   *entries ;
int      nD, nL, nU ;
/*
   ---------------
   check the input
   ---------------
*/
if ( chv == NULL || mtx == NULL ) {
   fprintf(stderr, "\n fatal error in DChv_fill21block(%p,%p)"
           "\n bad input\n", chv, mtx) ;
   exit(-1) ;
}
nD      = chv->nD      ;
nL      = chv->nL      ;
nU      = chv->nU      ;
entries = chv->entries ;
/*
   ----------------------------------
   resize the DA2 object as necessary
   ----------------------------------
*/
DA2_resize(mtx, nL, nD, nD, 1) ;
DA2_zero(mtx) ;
if ( chv->symflag > 0 ) {
   int   ii, iioff, ioff, istride, jj ;
/*
   ---------------------
   chv is nonsymmetric
   ---------------------
*/
   ioff = nD + nL - 1 ;
   istride = 2*nD + nU + nL - 2 ;
   for ( ii = 0 ; ii < nD ; ii++ ) {
      for ( jj = 0, iioff = ioff - nD + ii ; 
            jj < nL ; 
            jj++, iioff-- ) {
#if MYDEBUG > 0
         fprintf(stdout, 
             "\n 12: ii %d, jj %d, iioff %d, setting (%d,%d) = %20.12e",
              ii, jj, iioff, ii, ii, entries[iioff]) ;
#endif
         DA2_setEntry(mtx, jj, ii, entries[iioff]) ;
      }
      ioff += istride ;
      istride -= 2 ;
   }
}
return ; }

/*--------------------------------------------------------------------*/
