/*  basics.c  */

#include "../DChv.h"

#define   MYDEBUG 0

/*--------------------------------------------------------------------*/
/*
   -----------------------
   simplest constructor

   created -- 97apr23, cca
   -----------------------
*/
DChv *
DChv_new ( 
   void 
) {
DChv   *chv ;

ALLOCATE(chv, struct _DChv, 1) ;
DChv_setDefaultFields(chv) ;

return(chv) ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------
   set the default fields

   created -- 97apr23, cca
   -----------------------
*/
void
DChv_setDefaultFields (
   DChv   *chv
) {
if ( chv == NULL ) {
   fprintf(stderr, "\n fatal error in DChv_setDefaultFields(%p)"
           "\n bad input", chv) ;
   exit(-1) ;
}
chv->id      =  -1  ;
chv->nD      =   0  ;
chv->nL      =   0  ;
chv->nU      =   0  ;
chv->symflag =   0  ;
DV_setDefaultFields(&chv->wrkDV) ;
chv->rowind  = NULL ;
chv->colind  = NULL ;
chv->entries = NULL ;
chv->next    = NULL ;

return ; }

/*--------------------------------------------------------------------*/
/*
   --------------------------------------------------
   clear the data fields, releasing allocated storage

   created -- 97apr23, cca
   --------------------------------------------------
*/
void
DChv_clearData ( 
   DChv   *chv 
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( chv == NULL ) {
   fprintf(stderr, "\n fatal error in DChv_clearData(%p)"
           "\n bad input\n", chv) ;
   exit(-1) ;
}
/*
   ------------------------
   free the working storage
   ------------------------
*/
DV_clearData(&chv->wrkDV) ;
/*
   ----------------------
   set the default fields
   ----------------------
*/
DChv_setDefaultFields(chv) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   ------------------------------------------
   destructor, free's the object and its data

   created -- 97apr23, cca
   ------------------------------------------
*/
void
DChv_free ( 
   DChv   *chv 
) {
if ( chv == NULL ) {
   fprintf(stderr, "\n fatal error in DChv_free(%p)"
           "\n bad input\n", chv) ;
   exit(-1) ;
}
DChv_clearData(chv) ;
FREE(chv) ;

return ; }

/*--------------------------------------------------------------------*/
