/*  assemble.c  */

#include "../DChv.h"

#define MYDEBUG 0

/*--------------------------------------------------------------------*/
/*
   ----------------------------------------------------------------
   purpose -- assemble the postponed data from the children


   newchv     -- DChv object to contain fully assembled front
   oldchv     -- DChv object that contains former front
   firstchild -- pointer to first child in the list of children
                 DChv objects to be merged into the new front

   return value -- # of delayed rows and columns added to the front

   created -- 97may10, cca
   ----------------------------------------------------------------
*/
int
DChv_assemblePostponedData (
   DChv   *newchv,
   DChv   *oldchv,
   DChv   *firstchild
) {
DChv     *child ;
int      ierr, ndelay ;
/*
   ---------------
   check the input
   ---------------
*/
if ( newchv == NULL || oldchv == NULL || firstchild == NULL ) {
   fprintf(stderr, 
           "\n fatal error in DChv_assemblePostponedData(%p,%p,%p)"
           "\n bad input\n", newchv, oldchv, firstchild) ;
   exit(-1) ;
}
DChv_zero(newchv) ;
#if MYDEBUG > 0
fprintf(stdout, "\n\n inside DChv_assemblePostponedData, J = %d", 
        oldchv->id) ;
fprintf(stdout, "\n\n old chevron %d", oldchv->id) ;
DChv_writeForHumanEye(oldchv, stdout) ;
for ( child = firstchild ; child != NULL ; child = child->next ) {
   fprintf(stdout, "\n\n child %d", child->id) ;
   DChv_writeForHumanEye(child, stdout) ;
}
fprintf(stdout, "\n\n new chevron %d", newchv->id) ;
DChv_writeForHumanEye(newchv, stdout) ;
fflush(stdout) ;
#endif
/*
   ------------------------------------
   copy the indices into the new object
   ------------------------------------
*/
ndelay = 0 ;
for ( child = firstchild ; child != NULL ; child = child->next ) {
   IVcopy(child->nD, newchv->colind + ndelay, child->colind) ;
   ndelay += child->nD ;
}
IVcopy(oldchv->nD + oldchv->nU, 
       newchv->colind + ndelay, oldchv->colind) ;
#if MYDEBUG > 0
fprintf(stdout, "\n ndelay = %d, new column indices", ndelay) ;
IVfp80(stdout, newchv->nD + newchv->nU, newchv->colind, 80, &ierr) ;
fflush(stdout) ;
#endif
if ( newchv->symflag == 2 ) {
   ndelay = 0 ;
   for ( child = firstchild ; child != NULL ; child = child->next ) {
      IVcopy(child->nD, newchv->rowind + ndelay, child->rowind) ;
      ndelay += child->nD ;
   }
   IVcopy(oldchv->nD + oldchv->nU, 
          newchv->rowind + ndelay, oldchv->rowind) ;
#if MYDEBUG > 0
   fprintf(stdout, "\n ndelay = %d, new row indices", ndelay) ;
   IVfp80(stdout, newchv->nD + newchv->nL, newchv->rowind, 80, &ierr) ;
   fflush(stdout) ;
#endif
}
/*
   ------------------------
   assemble the old chevron
   ------------------------
*/
DChv_assembleDChv(newchv, oldchv) ;
#if MYDEBUG > 0
fprintf(stdout, "\n after merging old chevron") ;
DChv_writeForHumanEye(newchv, stdout) ;
#endif
/*
   ------------------------------
   assemble the children chevrons
   ------------------------------
*/
for ( child = firstchild ; child != NULL ; child = child->next ) {
   DChv_assembleDChv(newchv, child) ;
#if MYDEBUG > 0
   fprintf(stdout, "\n after merging child %d", child->id) ;
   DChv_writeForHumanEye(newchv, stdout) ;
#endif
}

return(ndelay) ; }

/*--------------------------------------------------------------------*/
