/*  test_swap.c  */

#include "../DChv.h"
#include "../../Drand.h"
#include "../../timings.h"

/*--------------------------------------------------------------------*/

void
main ( int argc, char *argv[] )
/*
   ----------------------------------------------
   test the swap methods

   created -- 97apr24, cca
   ----------------------------------------------
*/
{
DChv   *chv ;
double   t1, t2 ;
double   *entries ;
Drand    *drand ;
FILE     *msgFile ;
int      icol, irow, jcol, jrow, msglvl, ncol, nD, nent, nL, nrow, nU, 
         seed, symflag ;
int      *colind, *rowind ;

if ( argc != 12 ) {
   fprintf(stdout, 
           "\n\n usage : %s msglvl msgFile nD nL nU symflag seed "
           "\n         irow jrow icol jcol"
           "\n    msglvl  -- message level"
           "\n    msgFile -- message file"
           "\n    nD      -- # of rows and columns in the (1,1) block"
           "\n    nL      -- # of rows in the (2,1) block"
           "\n    nU      -- # of columns in the (1,2) block"
           "\n    symflag -- symmetry flag"
           "\n       0 --> symmetric"
           "\n       1 --> nonsymmetric"
           "\n    seed    -- random number seed"
           "\n    irow    -- first row to swap"
           "\n    jrow    -- second row to swap"
           "\n    icol    -- first column to swap"
           "\n    jcol    -- second column to swap"
           "\n", argv[0]) ;
   return ;
}
if ( (msglvl = atoi(argv[1])) < 0 ) {
   fprintf(stderr, "\n message level must be positive\n") ;
   exit(-1) ;
}
if ( strcmp(argv[2], "stdout") == 0 ) {
   msgFile = stdout ;
} else if ( (msgFile = fopen(argv[2], "a")) == NULL ) {
   fprintf(stderr, "\n unable to open file %s\n", argv[2]) ;
   return ;
}
nD      = atoi(argv[3]) ;
nL      = atoi(argv[4]) ;
nU      = atoi(argv[5]) ;
symflag = atoi(argv[6]) ;
seed    = atoi(argv[7]) ;
irow    = atoi(argv[8]) ;
jrow    = atoi(argv[9]) ;
icol    = atoi(argv[10]) ;
jcol    = atoi(argv[11]) ;
if (  nD <= 0 || nL < 0 || nU < 0 || symflag < 0 || symflag > 1 ) {
   fprintf(stderr, "\n invalid input"
      "\n nD = %d, nL = %d, nU = %d, symflag = %d\n",
           nD, nL, nU, symflag) ;
   exit(-1) ;
}
/*
   --------------------------------------
   initialize the random number generator
   --------------------------------------
*/
drand = Drand_new() ;
Drand_init(drand) ;
Drand_setSeed(drand, seed) ;
Drand_setNormal(drand, 0.0, 1.0) ;
/*
   ----------------------------
   initialize the DChv object
   ----------------------------
*/
MARKTIME(t1) ;
chv = DChv_new() ;
DChv_init(chv, 0, nD, nL, nU, symflag) ;
MARKTIME(t2) ;
fprintf(msgFile, "\n CPU : %.3f to initialize chv object",
        t2 - t1) ;
fflush(msgFile) ;
DChv_columnIndices(chv, &ncol, &colind) ;
IVramp(ncol, colind, 0, 1) ;
if ( symflag == 1 ) {
   DChv_rowIndices(chv, &nrow, &rowind) ;
   IVramp(nrow, rowind, 0, 1) ;
}
if ( msglvl > 0 ) {
   DChv_writeForHumanEye(chv, msgFile) ;
}
/*
   ------------------------------------
   load the entries with random entries
   ------------------------------------
*/
entries = DChv_entries(chv) ;
if ( symflag == 0 ) {
   nent = (nD*(nD+1))/2 + nD*nU ;
} else {
   nent = nD*(nD + nL + nU) ;
}
Drand_fillDvector(drand, nent, entries) ;
if ( msglvl > 0 ) {
   fprintf(msgFile, "\n raw entries vector") ;
   DVfprintf(msgFile, nent, entries) ;
   DChv_writeForHumanEye(chv, msgFile) ;
}
if ( symflag == 1 ) {
/*
   -------------
   swap the rows
   -------------
*/
   DChv_swapRows(chv, irow, jrow) ;
   if ( msglvl > 0 ) {
      fprintf(msgFile, 
              "\n\n after swapping rows %d and %d", irow, jrow) ;
      DChv_writeForHumanEye(chv, msgFile) ;
   }
/*
   ----------------
   swap the columns
   ----------------
*/
   DChv_swapColumns(chv, icol, jcol) ;
   if ( msglvl > 0 ) {
      fprintf(msgFile, "\n\n after swapping columns %d and %d", 
              icol, jcol) ;
      DChv_writeForHumanEye(chv, msgFile) ;
   }
} else {
/*
   -------------------------
   swap the rows and columns
   -------------------------
*/
   DChv_swapRowsAndColumns(chv, irow, jrow) ;
   if ( msglvl > 0 ) {
      fprintf(msgFile, 
              "\n\n after swapping rows and columns %d and %d", 
              irow, jrow) ;
      DChv_writeForHumanEye(chv, msgFile) ;
   }
}

fprintf(msgFile, "\n") ;

return ; }

/*--------------------------------------------------------------------*/
