/*  test_asssembly.c  */

#include "../DChv.h"
#include "../../Drand.h"
#include "../../timings.h"

/*--------------------------------------------------------------------*/
/*
   --------------------
   static data for test
   --------------------
*/
int   nDI1 = 2, nLI1 = 5, nUI1 = 5 ;
int   nDI2 = 1, nLI2 = 5, nUI2 = 5 ;
int   nDI3 = 3, nLI3 = 6, nUI3 = 6 ;
int   nDJ = 4, nLJ = 5, nUJ = 5 ;
int   colindI1[] = { 5, 7, 27, 33, 44, 66, 77 } ;
int   colindI2[] = { 10, 30, 33, 77, 88, 99 } ;
int   colindI3[] = { 14, 18, 12, 27, 33, 55, 66, 77, 99 } ;
int   colindJ[]  = { 27, 30, 33, 44, 55, 66, 77, 88, 99 } ;
int   rowindI1[] = { 6, 4, 27, 33, 44, 66, 77 } ;
int   rowindI2[] = { 0, 30, 33, 77, 88, 99 } ;
int   rowindI3[] = { 9, 15, 11, 27, 33, 55, 66, 77, 99 } ;
int   rowindJ[]  = { 27, 30, 33, 44, 55, 66, 77, 88, 99 } ;
/*--------------------------------------------------------------------*/

void
main ( int argc, char *argv[] )
/*
   ----------------------------------------------------------
   test the assembly of postponed data.

   created -- 97may10, cca
   ----------------------------------------------------------
*/
{
DChv     *chvI1, *chvI2, *chvI3, *chvJ, *chvK ;
double   t1, t2 ;
double   *entriesI1, *entriesI2, *entriesI3, *entriesJ ;
Drand    *drand ;
FILE     *msgFile ;
int      ierr, msglvl, nentI1, nentI2, nentJ, nentI3, seed, symflag ;

if ( argc != 5 ) {
   fprintf(stdout, 
"\n"
"\n test_assembly: assemble postponed chevrons"
"\n"
"\n\n usage : %s msglvl msgFile symflag seed"
"\n    msglvl  -- message level"
"\n    msgFile -- message file"
"\n    symflag -- symmetry flag"
"\n       0 --> symmetric structure, symmetric entries"
"\n       1 --> symmetric structure, nonsymmetric entries"
"\n       2 --> nonsymmetric structure, nonsymmetric entries"
"\n    seed    -- random number seed"
"\n", argv[0]) ;
   return ;
}
if ( (msglvl = atoi(argv[1])) < 0 ) {
   fprintf(stderr, "\n message level must be positive\n") ;
   exit(-1) ;
}
if ( strcmp(argv[2], "stdout") == 0 ) {
   msgFile = stdout ;
} else if ( (msgFile = fopen(argv[2], "a")) == NULL ) {
   fprintf(stderr, "\n unable to open file %s\n", argv[2]) ;
   return ;
}
symflag = atoi(argv[3]) ;
seed    = atoi(argv[4]) ;
if (  symflag < 0 || symflag > 2 ) {
   fprintf(stderr, "\n invalid input"
      "\n symflag = %d\n", symflag) ;
   exit(-1) ;
}
/*
   --------------------------------------
   initialize the random number generator
   --------------------------------------
*/
drand = Drand_new() ;
Drand_init(drand) ;
Drand_setSeed(drand, seed) ;
Drand_setNormal(drand, 0.0, 1.0) ;
/*
   ---------------------------
   initialize the DChv objects
   ---------------------------
*/
MARKTIME(t1) ;
chvI1 = DChv_new() ;
DChv_init(chvI1, 1, nDI1, nUI1, nUI1, symflag) ;
if ( symflag != 0 ) {
   IVcopy(nDI1 + nUI1, chvI1->rowind, rowindI1) ;
}
IVcopy(nDI1 + nUI1, chvI1->colind, colindI1) ;

chvI2 = DChv_new() ;
DChv_init(chvI2, 2, nDI2, nUI2, nUI2, symflag) ;
if ( symflag != 0 ) {
   IVcopy(nDI2 + nUI2, chvI2->rowind, rowindI2) ;
}
IVcopy(nDI2 + nUI2, chvI2->colind, colindI2) ;

chvI3 = DChv_new() ;
DChv_init(chvI3, 3, nDI3, nUI3, nUI3, symflag) ;
if ( symflag != 0 ) {
   IVcopy(nDI3 + nUI3, chvI3->rowind, rowindI3) ;
}
IVcopy(nDI3 + nUI3, chvI3->colind, colindI3) ;

chvJ = DChv_new() ;
DChv_init(chvJ, 4, nDJ, nUJ, nUJ, symflag) ;
if ( symflag != 0 ) {
   IVcopy(nDJ + nUJ, chvJ->rowind, rowindJ) ;
}
IVcopy(nDJ + nUJ, chvJ->colind, colindJ) ;

chvI1->next = chvI2 ;
chvI2->next = chvI3 ;
chvI3->next = NULL  ;

MARKTIME(t2) ;
/*
   --------------------------
   link the chevrons together
   --------------------------
*/
chvI1->next = chvI2 ;
chvI2->next = chvI3 ;
chvI3->next = NULL  ;
/*
   ----------------------------------------------------
   fill the entries of J, I1 and I2 with random numbers
   ----------------------------------------------------
*/
if ( symflag == 0 ) {
   nentJ  = (nDJ*(nDJ+1))/2 + nDJ*nUJ ;
   nentI1 = (nDI1*(nDI1+1))/2 + nDI1*nUI1 ;
   nentI2 = (nDI2*(nDI2+1))/2 + nDI2*nUI2 ;
   nentI3 = (nDI3*(nDI3+1))/2 + nDI3*nUI3 ;
} else {
   nentJ  = nDJ*(nDJ + 2*nUJ) ;
   nentI1  = nDI1*(nDI1 + 2*nUI1) ;
   nentI2  = nDI2*(nDI2 + 2*nUI2) ;
   nentI3  = nDI3*(nDI3 + 2*nUI3) ;
}
entriesJ  = DChv_entries(chvJ)  ;
entriesI1 = DChv_entries(chvI1) ;
entriesI2 = DChv_entries(chvI2) ;
entriesI3 = DChv_entries(chvI3) ;
Drand_fillDvector(drand, nentJ, entriesJ) ;
Drand_fillDvector(drand, nentI1, entriesI1) ;
Drand_fillDvector(drand, nentI2, entriesI2) ;
Drand_fillDvector(drand, nentI3, entriesI3) ;
/*
   -------------------------------
   print out the four DChv objects
   -------------------------------
*/
if ( msglvl > 2 ) {
   fprintf(msgFile, "\n\n DChv J") ;
   DChv_writeForHumanEye(chvJ, msgFile) ;
   fprintf(msgFile, "\n\n DChv I1") ;
   DChv_writeForHumanEye(chvI1, msgFile) ;
   fprintf(msgFile, "\n\n DChv I2") ;
   DChv_writeForHumanEye(chvI2, msgFile) ;
   fprintf(msgFile, "\n\n DChv I3") ;
   DChv_writeForHumanEye(chvI3, msgFile) ;
}
/*
   ---------------------------
   assemble the postponed data
   ---------------------------
*/
chvK = DChv_new() ;
DChv_init(chvK, 5, nDJ + nDI1 + nDI2 + nDI3, nUJ, nUJ, symflag) ;
DChv_assemblePostponedData(chvK, chvJ, chvI1) ;
if ( msglvl > 2 ) {
   fprintf(msgFile, "\n\n after assembly ") ;
   DChv_writeForHumanEye(chvK, msgFile) ;
   fflush(msgFile) ;
}

fprintf(msgFile, "\n") ;

return ; }

/*--------------------------------------------------------------------*/
