/*  test_addChevron.c  */

#include "../DChv.h"
#include "../../Drand.h"
#include "../../timings.h"

/*--------------------------------------------------------------------*/

void
main ( int argc, char *argv[] )
/*
   ---------------------------------------
   test the DChv_addChevron() method.
   note: symflag = 0 or 1.

   created -- 97apr26, cca
   ---------------------------------------
*/
{
DChv     *chv ;
double   alpha, t1, t2 ;
double   *chvent ;
Drand    *drand ;
FILE     *msgFile ;
int      chvsize, count, ichv, ierr, ii, iloc, irow, msglvl, jcol,
         ncol, nD, nL, nrow, nU, seed, symflag, upper ;
int      *chvind, *colind, *keys, *rowind, *temp ;

if ( argc != 9 ) {
   fprintf(stdout, 
           "\n\n usage : %s msglvl msgFile nD nL nU symflag seed "
           "\n    msglvl  -- message level"
           "\n    msgFile -- message file"
           "\n    nD      -- # of rows and columns in the (1,1) block"
           "\n    nL      -- # of rows in the (2,1) block"
           "\n    nU      -- # of columns in the (1,2) block"
           "\n    symflag -- symmetry flag"
           "\n       0 --> symmetric"
           "\n       1 --> nonsymmetric"
           "\n    seed    -- random number seed"
           "\n    alpha   -- scaling parameter"
           "\n", argv[0]) ;
   return ;
}
if ( (msglvl = atoi(argv[1])) < 0 ) {
   fprintf(stderr, "\n message level must be positive\n") ;
   exit(-1) ;
}
if ( strcmp(argv[2], "stdout") == 0 ) {
   msgFile = stdout ;
} else if ( (msgFile = fopen(argv[2], "a")) == NULL ) {
   fprintf(stderr, "\n unable to open file %s\n", argv[2]) ;
   return ;
}
nD      = atoi(argv[3]) ;
nL      = atoi(argv[4]) ;
nU      = atoi(argv[5]) ;
symflag = atoi(argv[6]) ;
seed    = atoi(argv[7]) ;
alpha   = atof(argv[8]) ;
if (  nD <= 0 || nL < 0 || nU < 0 || symflag < 0 || symflag > 2 ) {
   fprintf(stderr, "\n invalid input"
      "\n nD = %d, nL = %d, nU = %d, symflag = %d\n",
           nD, nL, nU, symflag) ;
   exit(-1) ;
}
/*
   --------------------------------------
   initialize the random number generator
   --------------------------------------
*/
drand = Drand_new() ;
Drand_init(drand) ;
Drand_setSeed(drand, seed) ;
Drand_setNormal(drand, 0.0, 1.0) ;
/*
   ----------------------------
   initialize the DChv object
   ----------------------------
*/
MARKTIME(t1) ;
chv = DChv_new() ;
DChv_init(chv, 0, nD, nL, nU, symflag) ;
MARKTIME(t2) ;
fprintf(msgFile, "\n CPU : %.3f to initialize chv object",
        t2 - t1) ;
fflush(msgFile) ;
DChv_columnIndices(chv, &ncol, &colind) ;
temp = IVinit(1000, -1) ;
IVramp(1000, temp, 0, 1) ;
IVshuffle(1000, temp, ++seed) ;
IVcopy(ncol, colind, temp) ;
IVqsortUp(ncol, colind) ;
if ( symflag == 2 ) {
   DChv_rowIndices(chv, &nrow, &rowind) ;
   IVshuffle(1000, temp, ++seed) ;
   IVcopy(nrow, rowind, temp) ;
   IVqsortUp(nrow, rowind) ;
}
if ( msglvl > 3 ) {
   DChv_writeForHumanEye(chv, msgFile) ;
}
/*
   ---------------------------
   fill the entries with zeros
   ---------------------------
*/
DChv_zero(chv) ;
if ( msglvl > 2 ) {
   fprintf(msgFile, "\n\n after entries have been zero'd") ;
   DChv_writeForHumanEye(chv, msgFile) ;
}
/*
   --------------------------------------------------
   fill a chevron with random numbers and indices
   that are a subset of a front's, as in the assembly
   of original matrix entries.
   --------------------------------------------------
*/
Drand_setUniform(drand, 0, nD) ;
iloc = (int) Drand_value(drand) ;
ichv = colind[iloc] ;
if ( symflag == 0 ) {
   upper = nD - iloc + nU ;
} else {
   upper = 2*(nD - iloc) - 1 + nL + nU ;
}
Drand_setUniform(drand, 1, upper) ;
chvsize = (int) Drand_value(drand) ;
chvind  = IVinit(chvsize, -1) ;
chvent  = DVinit(chvsize, 0.0) ;
Drand_setNormal(drand, 0.0, 1.0) ;
Drand_fillDvector(drand, chvsize, chvent) ;
keys    = IVinit(upper+1, -1) ;
keys[0] = 0 ;
if ( symflag == 0 ) {
   for ( ii = iloc + 1, count = 1 ; ii < nD + nU ; ii++ ) {
      keys[count++] = colind[ii] - ichv ;
   }
} else {
   for ( ii = iloc + 1, count = 1 ; ii < nD + nU ; ii++ ) {
      keys[count++] =   colind[ii] - ichv ;
      keys[count++] = - colind[ii] + ichv ;
   }
}
if ( msglvl > 2 ) {
   fprintf(msgFile, "\n iloc = %d, ichv = %d", iloc, ichv) ;
   fprintf(msgFile, "\n upper = %d", upper) ;
   fprintf(msgFile, "\n chvsize = %d", chvsize) ;
   fprintf(msgFile, "\n initial keys") ;
   IVfp80(msgFile, count, keys, 80, &ierr) ;
}
   IVshuffle(count, keys, ++seed) ;
if ( msglvl > 2 ) {
   fprintf(msgFile, "\n shuffled keys") ;
   IVfp80(msgFile, count, keys, 80, &ierr) ;
}
IVcopy(chvsize, chvind, keys) ;
IVDVqsortUp(chvsize, chvind, chvent) ;
if ( msglvl > 2 ) {
   fprintf(msgFile, "\n\n chevron %d, size %d", ichv, chvsize) ;
   IVfp80(msgFile, chvsize, chvind, 80, &ierr) ;
   DVfprintf(msgFile, chvsize, chvent) ;
}
/*
   ------------------------------------
   add the chevron into the DChv object
   ------------------------------------
*/
DChv_addChevron(chv, alpha, ichv, chvsize, chvind, chvent) ;
if ( msglvl > 2 ) {
   fprintf(msgFile, "\n after adding the chevron") ;
   DChv_writeForHumanEye(chv, msgFile) ;
}
/*
   --------------------------------------
   now subtract the entries one at a time
   --------------------------------------
*/
for ( ii = 0 ; ii < chvsize ; ii++ ) {
   if ( chvind[ii] < 0 ) {
      irow = ichv - chvind[ii] ;
      jcol = ichv ;
   } else {
      jcol = ichv + chvind[ii] ;
      irow = ichv ;
   }
   DChv_addEntry(chv, irow, jcol, -alpha*chvent[ii]) ;
}
fprintf(msgFile, "\n after subtracting the chevron, error = %12.4e",
        DChv_maxabs(chv)) ;
if ( msglvl > 2 ) {
   fprintf(msgFile, "\n after subtracting the chevron") ;
   DChv_writeForHumanEye(chv, msgFile) ;
}

fprintf(msgFile, "\n") ;

return ; }

/*--------------------------------------------------------------------*/
