/*  scale.c  */

#include "../DA2.h"

/*--------------------------------------------------------------------*/
/*
   -----------------------------
   purpose -- replace A by B * A 

   created -- 96sep14, cca
   -----------------------------
*/
void
DA2_scaleOnLeft (
   DA2   *A,
   DA2   *B,
   DV    *tmpDV
) {
int   ncolA, nrowA ;
/*
   ---------------
   check the input
   ---------------
*/
if ( A == NULL || B == NULL || tmpDV == NULL ) {
   fprintf(stderr, "\n fatal error in DA2_scaleOnLeft(%p,%p,%p)"
           "\n bad input\n", A, B, tmpDV) ;
   exit(-1) ;
}
nrowA = A->n1 ;
ncolA = A->n2 ;
if (  nrowA < 0 || ncolA < 0 || nrowA != B->n1 || nrowA != B->n2 ) {
   fprintf(stderr, "\n fatal error in DA2_scaleOnLeft(%p,%p,%p)"
           "\n bad matrices"
           "\n nrowA = %d, ncolA = %d, nrowB = %d, ncolB = %d",
           A, B, tmpDV, nrowA, ncolA, B->n1, B->n2) ;
   exit(-1) ;
}
/*
   --------------------------
   loop over the columns of A
   --------------------------
*/
if ( A->inc1 == 1 ) {
   double   *x0, *x1, *x2, *y0, *y1, *y2 ;
   int      jcol ;
/*
   -------------------------
   resize tmpDV if necessary
   -------------------------
*/
   if ( DV_size(tmpDV) < 3*nrowA ) {
      DV_setSize(tmpDV, 3*nrowA) ;
   }
   y0 = DV_entries(tmpDV) ;
   y1 = y0 + nrowA ;
   y2 = y1 + nrowA ;
/*
   -----------------------------------------
   multiply three right hand sides at a time
   -----------------------------------------
*/
   x0 = A->entries ;
   for ( jcol = 0 ; jcol < ncolA - 2 ; jcol += 3 ) {
      x1 = x0 + A->inc2 ;
      x2 = x1 + A->inc2 ;
      DVzero(3*nrowA, y0) ;
      DA2_mvm3vec(B, y0, y1, y2, 1.0, x0, x1, x2) ;
      DA2_setColumn(A, y0, jcol) ;
      DA2_setColumn(A, y1, jcol+1) ;
      DA2_setColumn(A, y2, jcol+2) ;
      x0 = x2 + A->inc2 ;
   }
   if ( jcol == ncolA - 2 ) {
/*
      --------------------------------
      do the two last right hand sides
      --------------------------------
*/
      x1 = x0 + A->inc2 ;
      DVzero(2*nrowA, y0) ;
      DA2_mvm2vec(B, y0, y1, 1.0, x0, x1) ;
      DA2_setColumn(A, y0, jcol) ;
      DA2_setColumn(A, y1, jcol+1) ;
   } else if ( jcol == ncolA - 1 ) {
/*
      ---------------------------
      do the last right hand side
      ---------------------------
*/
      DVzero(nrowA, y0) ;
      DA2_mvm1vec(B, y0, 1.0, x0) ;
      DA2_setColumn(A, y0, jcol) ;
   }
} else {
   double   *x0, *x1, *x2, *y0, *y1, *y2 ;
   int      jcol ;
/*
   -------------------------
   resize tmpDV if necessary
   -------------------------
*/
   if ( DV_size(tmpDV) < 6*nrowA ) {
      DV_setSize(tmpDV, 6*nrowA) ;
   }
   y0 = DV_entries(tmpDV) ;
   y1 = y0 + nrowA ;
   y2 = y1 + nrowA ;
   x0 = y2 + nrowA ;
   x1 = x0 + nrowA ;
   x2 = x1 + nrowA ;
/*
   -----------------------------------------
   multiply three right hand sides at a time
   -----------------------------------------
*/
   for ( jcol = 0 ; jcol < ncolA - 2 ; jcol += 3 ) {
      DA2_extractColumn(A, x0, jcol) ;
      DA2_extractColumn(A, x1, jcol+1) ;
      DA2_extractColumn(A, x2, jcol+2) ;
      DVzero(3*nrowA, y0) ;
      DA2_mvm3vec(B, y0, y1, y2, 1.0, x0, x1, x2) ;
      DA2_setColumn(A, y0, jcol) ;
      DA2_setColumn(A, y1, jcol+1) ;
      DA2_setColumn(A, y2, jcol+2) ;
   }
   if ( jcol == ncolA - 2 ) {
/*
      --------------------------------
      do the two last right hand sides
      --------------------------------
*/
      DA2_extractColumn(A, x0, jcol) ;
      DA2_extractColumn(A, x1, jcol+1) ;
      DVzero(2*nrowA, y0) ;
      DA2_mvm2vec(B, y0, y1, 1.0, x0, x1) ;
      DA2_setColumn(A, y0, jcol) ;
      DA2_setColumn(A, y1, jcol+1) ;
   } else if ( jcol == ncolA - 1 ) {
/*
      ---------------------------
      do the last right hand side
      ---------------------------
*/
      DA2_extractColumn(A, x0, jcol) ;
      DVzero(nrowA, y0) ;
      DA2_mvm1vec(B, y0, 1.0, x0) ;
      DA2_setColumn(A, y0, jcol) ;
   }
}

return ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------------
   purpose -- replace A by A * B

   created -- 96sep14, cca
   -----------------------------
*/
void
DA2_scaleOnRight (
   DA2   *A,
   DA2   *B,
   DV    *tmpDV
) {
int   ncolA, nrowA ;
/*
   ---------------
   check the input
   ---------------
*/
if ( A == NULL || B == NULL || tmpDV == NULL ) {
   fprintf(stderr, "\n fatal error in DA2_scaleOnRight(%p,%p,%p)"
           "\n bad input\n", A, B, tmpDV) ;
   exit(-1) ;
}
nrowA = A->n1 ;
ncolA = A->n2 ;
if (  nrowA < 0 || ncolA < 0 || ncolA != B->n1 || ncolA != B->n2 ) {
   fprintf(stderr, "\n fatal error in DA2_scaleOnRight(%p,%p,%p)"
           "\n bad matrices"
           "\n nrowA = %d, ncolA = %d, nrowB = %d, ncolB = %d",
           A, B, tmpDV, nrowA, ncolA, B->n1, B->n2) ;
   exit(-1) ;
}
DA2_transpose(A) ;
DA2_transpose(B) ;
DA2_scaleOnLeft(A, B, tmpDV) ;
DA2_transpose(A) ;
DA2_transpose(B) ;

return ; }

/*--------------------------------------------------------------------*/
