/*  instance.c  */

#include "../DA2.h"

/*--------------------------------------------------------------------*/
/*
   --------------------------------------
   return the number of rows in the array

   created -- 96apr27, cca
   --------------------------------------
*/
int
DA2_nrow ( 
   DA2   *mtx
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( mtx == NULL ) {
   fprintf(stderr, "\n fatal error in DA2_nrow(%p)"
           "\n bad input\n", mtx) ;
   exit(-1) ;
}
return(mtx->n1) ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------------------------
   return the number of columns in the array

   created -- 96apr27, cca
   -----------------------------------------
*/
int
DA2_ncol ( 
   DA2   *mtx
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( mtx == NULL ) {
   fprintf(stderr, "\n fatal error in DA2_ncol(%p)"
           "\n bad input\n", mtx) ;
   exit(-1) ;
}
return(mtx->n2) ; }

/*--------------------------------------------------------------------*/
/*
   --------------------------
   return the first increment

   created -- 96nov18, cca
   --------------------------
*/
int
DA2_inc1 ( 
   DA2  *mtx
) {
/*
   ---------------
   check the input
   ---------------
*/
if (  mtx == NULL ) {
   fprintf(stderr, "\n fatal error in DA2_inc1(%p)"
           "\n bad input\n", mtx) ;
   exit(-1) ;
}
return(mtx->inc1) ; }

/*--------------------------------------------------------------------*/
/*
   ---------------------------
   return the second increment

   created -- 96nov18, cca
   ---------------------------
*/
int
DA2_inc2 ( 
   DA2  *mtx
) {
/*
   ---------------
   check the input
   ---------------
*/
if (  mtx == NULL ) {
   fprintf(stderr, "\n fatal error in DA2_inc2(%p)"
           "\n bad input\n", mtx) ;
   exit(-1) ;
}
return(mtx->inc2) ; }

/*--------------------------------------------------------------------*/
/*
   -------------------------------
   return a pointer to the entries

   created -- 96apr19, cca
   -------------------------------
*/
double *
DA2_entries ( 
   DA2      *mtx
) {
/*
   ---------------
   check the input
   ---------------
*/
if (  mtx == NULL ) {
   fprintf(stderr, "\n fatal error in DA2_entries(%p)"
           "\n bad input\n", mtx) ;
   exit(-1) ;
}
return(mtx->entries) ; }

/*--------------------------------------------------------------------*/
/*
   --------------------------------------------
   return a pointer to the first entry in a row

   created -- 96nov27, cca
   --------------------------------------------
*/
double *
DA2_row ( 
   DA2   *mtx,
   int   irow
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( mtx == NULL ) {
   fprintf(stderr, "\n fatal error in DA2_row(%p,%d)"
           "\n bad input\n", mtx, irow) ;
   exit(-1) ;
}
if ( mtx->entries == NULL ) {
   fprintf(stderr, "\n fatal error in DA2_row(%p,%d)"
           "\n bad structure, entries is NULL\n", mtx, irow) ;
   exit(-1) ;
}
if ( irow < 0 || irow >= mtx->n1 ) {
   fprintf(stderr, "\n fatal error in DA2_row(%p,%d)"
           "\n bad input, irow = %d, n1 = %d\n", 
           mtx, irow, irow, mtx->n1) ;
   exit(-1) ;
}
return(mtx->entries + irow*mtx->inc1) ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------------------------------
   return a pointer to the first entry in a column

   created -- 96nov27, cca
   -----------------------------------------------
*/
double *
DA2_column ( 
   DA2   *mtx,
   int   jcol
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( mtx == NULL ) {
   fprintf(stderr, "\n fatal error in DA2_column(%p,%d)"
           "\n bad input\n", mtx, jcol) ;
   exit(-1) ;
}
if ( mtx->entries == NULL ) {
   fprintf(stderr, "\n fatal error in DA2_column(%p,%d)"
           "\n bad structure, entries is NULL\n", mtx, jcol) ;
   exit(-1) ;
}
if ( jcol < 0 || jcol >= mtx->n2 ) {
   fprintf(stderr, "\n fatal error in DA2_column(%p,%d)"
           "\n bad input, jcol = %d, n2 = %d\n", 
           mtx, jcol, jcol, mtx->n2) ;
   exit(-1) ;
}
return(mtx->entries + jcol*mtx->inc2) ; }

/*--------------------------------------------------------------------*/
/*
   ------------------------------------------
   return a pointer to the matrix first entry
   in row irow and column jcol

   created -- 96nov27, cca
   ------------------------------------------
*/
double *
DA2_pointerToEntry ( 
   DA2   *mtx,
   int   irow,
   int   jcol
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( mtx == NULL ) {
   fprintf(stderr, "\n fatal error in DA2_pointerToEntry(%p,%d,%d)"
           "\n bad input\n", mtx, irow, jcol) ;
   exit(-1) ;
}
if ( mtx->entries == NULL ) {
   fprintf(stderr, "\n fatal error in DA2_pointerToEntry(%p,%d,%d)"
           "\n bad structure, entries is NULL\n", mtx, irow, jcol) ;
   exit(-1) ;
}
if ( irow < 0 || irow >= mtx->n1 ) {
   fprintf(stderr, "\n fatal error in DA2_pointerToEntry(%p,%d,%d)"
           "\n bad input, irow = %d, n1 = %d\n", 
           mtx, irow, jcol, irow, mtx->n1) ;
   exit(-1) ;
}
if ( jcol < 0 || jcol >= mtx->n2 ) {
   fprintf(stderr, "\n fatal error in DA2_pointerToEntry(%p,%d,%d)"
           "\n bad input, jcol = %d, n2 = %d\n", 
           mtx, irow, jcol, jcol, mtx->n2) ;
   exit(-1) ;
}
return(mtx->entries + irow*mtx->inc1 + jcol*mtx->inc2) ; }

/*--------------------------------------------------------------------*/
