/*  basics.c  */

#include "../DA2.h"

#define   MYDEBUG 0

/*--------------------------------------------------------------------*/
/*
   -----------------------
   simplest constructor

   created -- 96apr19, cca
   -----------------------
*/
DA2 *
DA2_new ( 
   void 
) {
DA2   *mtx ;

ALLOCATE(mtx, struct _DA2, 1) ;
DA2_setDefaultFields(mtx) ;

return(mtx) ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------
   set the default fields

   created -- 96apr19, cca
   -----------------------
*/
void
DA2_setDefaultFields (
   DA2   *mtx
) {
if ( mtx == NULL ) {
   fprintf(stderr, "\n fatal error in DA2_setDefaultFields(%p)"
           "\n bad input", mtx) ;
   exit(-1) ;
}
mtx->n1      =   0  ;
mtx->inc1    =   0  ;
mtx->n2      =   0  ;
mtx->inc2    =   0  ;
mtx->nowned  =   0  ;
mtx->entries = NULL ;

return ; }

/*--------------------------------------------------------------------*/
/*
   --------------------------------------------------
   clear the data fields, releasing allocated storage

   created -- 96apr19, cca
   --------------------------------------------------
*/
void
DA2_clearData ( 
   DA2   *mtx 
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( mtx == NULL ) {
   fprintf(stderr, "\n fatal error in DA2_clearData(%p)"
           "\n bad input\n", mtx) ;
   exit(-1) ;
}
/*
   -------------------------------------
   free the entries if present and owned
   -------------------------------------
*/
if ( mtx->nowned > 0 && mtx->entries != NULL ) {
   DVfree(mtx->entries) ;
}
/*
   ----------------------
   set the default fields
   ----------------------
*/
DA2_setDefaultFields(mtx) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   ------------------------------------------
   destructor, free's the object and its data

   created -- 96apr19, cca
   ------------------------------------------
*/
void
DA2_free ( 
   DA2   *mtx 
) {
if ( mtx == NULL ) {
   fprintf(stderr, "\n fatal error in DA2_free(%p)"
           "\n bad input\n", mtx) ;
   exit(-1) ;
}
DA2_clearData(mtx) ;
FREE(mtx) ;

return ; }

/*--------------------------------------------------------------------*/
